/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.AbstractBaseListSupport;
import cdc.enums.DagFeature;
import cdc.enums.DagType;
import java.util.function.Consumer;

public abstract class AbstractBaseDagSupport<V>
extends AbstractBaseListSupport<V>
implements DagType<V> {
    protected AbstractBaseDagSupport(Class<V> cls, DagFeature ... features) {
        super(cls, features);
    }

    protected final void iterateUnder(V value, Consumer<V> consumer) {
        consumer.accept(value);
        for (V child : this.getChildren(value)) {
            this.iterateUnder(child, consumer);
        }
    }

    protected final void iterateOver(V value, Consumer<V> consumer) {
        consumer.accept(value);
        for (V parent : this.getParents(value)) {
            this.iterateOver(parent, consumer);
        }
    }

    protected final void checkIsNotOverOrEqual(V value, V other) {
        if (other != null) {
            this.iterateOver(other, v -> {
                if (v == value) {
                    throw new IllegalArgumentException(String.valueOf(value) + " is over or equal to " + String.valueOf(other));
                }
            });
        }
    }
}

