/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.enums.DagEvent;
import cdc.enums.DagEventHandler;
import cdc.enums.DagEventType;
import cdc.enums.DagFeature;
import cdc.enums.ListType;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBaseListSupport<V>
implements ListType<V> {
    protected final Logger logger;
    private final Set<DagFeature> features;
    private final Class<V> cls;
    private final List<DagEventHandler> handlers = new ArrayList<DagEventHandler>();

    protected AbstractBaseListSupport(Class<V> cls, DagFeature ... features) {
        Checks.isNotNull(cls, (String)"cls");
        this.logger = LogManager.getLogger((String)(this.getClass().getCanonicalName() + "<" + cls.getCanonicalName() + ">"));
        this.cls = cls;
        this.features = EnumSet.of(DagFeature.LOCKING, features);
        this.features.add(DagFeature.CREATION);
    }

    @Override
    public final void addEventHandler(DagEventHandler handler) {
        if (handler != null && !this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    @Override
    public final void removeEventHandler(DagEventHandler handler) {
        this.handlers.remove(handler);
    }

    protected final void fire(V value, DagEventType eventType) {
        if (!this.handlers.isEmpty()) {
            DagEvent event = new DagEvent(this, value, eventType);
            for (DagEventHandler handler : this.handlers) {
                handler.processEvent(event);
            }
        }
    }

    @Override
    public final boolean isSupported(DagFeature feature) {
        Checks.isNotNull((Object)((Object)feature), (String)"feature");
        return this.features.contains((Object)feature);
    }

    @Override
    public final Class<V> getValueClass() {
        return this.cls;
    }

    protected final void checkIsValid(V value) {
        if (value == null || !this.isValid(value)) {
            throw new IllegalArgumentException("Invalid value: " + String.valueOf(value));
        }
        if (!this.isContained(value)) {
            throw new IllegalArgumentException("Unrelated value: " + String.valueOf(value));
        }
    }

    protected final void checkIsSupported(DagFeature feature) {
        if (!this.isSupported(feature)) {
            throw new UnsupportedOperationException("Unsupported feature: " + String.valueOf((Object)feature));
        }
    }

    protected abstract boolean isContained(V var1);
}

