/*
 * Decompiled with CFR 0.152.
 */
package cdc.enums;

import cdc.args.AbstractFactory;
import cdc.args.Args;
import cdc.args.Factory;
import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.args.Necessity;
import cdc.converters.Converter;
import cdc.converters.defaults.AbstractSequenceConverter;
import cdc.enums.Mask;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;

public class AbstractMaskToString<M extends Mask<M, V>, V>
extends AbstractSequenceConverter<M, String> {
    private final Converter<? super V, String> converter;
    public static final FormalArg<Converter<?, String>> CONVERTER = new FormalArg("converter", Introspection.uncheckedCast(Converter.class), Necessity.MANDATORY);
    public static final FormalArgs FPARAMS = new FormalArgs(new FormalArg[]{PREFIX, SEPARATOR, SUFFIX, CONVERTER});

    protected static <C extends AbstractMaskToString<M, V>, M extends Mask<M, V>, V> Factory<C> factory(Class<C> converterClass, Class<M> maskClass, final Class<V> valueClass, final Creator<C, V> creator) {
        return new AbstractFactory<C>(converterClass, Args.builder().arg(SOURCE_CLASS, maskClass).arg(TARGET_CLASS, String.class).build(), new FormalArgs[]{FPARAMS}){

            protected C create(Args args, FormalArgs fargs) {
                String prefix = (String)args.getValue(AbstractSequenceConverter.PREFIX, null);
                String separator = (String)args.getValue(AbstractSequenceConverter.SEPARATOR, null);
                String suffix = (String)args.getValue(AbstractSequenceConverter.SUFFIX, null);
                Converter converter = (Converter)Introspection.uncheckedCast((Object)args.getValue(CONVERTER));
                Checks.isTrue((boolean)converter.isCompliantSourceClass(valueClass), (String)"Non compliant converter");
                return (Object)((AbstractMaskToString)((Object)creator.create(prefix, separator, suffix, converter)));
            }
        };
    }

    protected AbstractMaskToString(Class<M> maskClass, String prefix, String separator, String suffix, Converter<? super V, String> converter) {
        super(maskClass, String.class, prefix, separator, suffix);
        this.converter = converter;
    }

    public static <M extends Mask<M, V>, V> AbstractMaskToString<M, V> create(Class<M> maskClass, String prefix, String separator, String suffix, Converter<? super V, String> converter) {
        return new AbstractMaskToString<M, V>(maskClass, prefix, separator, suffix, converter);
    }

    public Converter<? super V, String> getConverter() {
        return this.converter;
    }

    public String apply(M mask) {
        if (mask == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getPrefix());
        boolean first = true;
        for (Object value : mask.getSupport().getType().getValues()) {
            if (!mask.isSet(value)) continue;
            if (!first) {
                builder.append(this.getSeparator());
            } else {
                first = false;
            }
            builder.append((String)this.converter.apply(value));
        }
        builder.append(this.getSuffix());
        return builder.toString();
    }

    public Args getParams() {
        return Args.builder().arg(PREFIX, (Object)this.getPrefix()).arg(SEPARATOR, (Object)this.getSeparator()).arg(SUFFIX, (Object)this.getSuffix()).arg(CONVERTER, this.getConverter()).build();
    }

    @FunctionalInterface
    protected static interface Creator<C, S> {
        public C create(String var1, String var2, String var3, Converter<? super S, String> var4);
    }
}

