/*
 * Decompiled with CFR 0.152.
 */
package cdc.prefs;

import cdc.prefs.Prefs;
import cdc.prefs.file.FilePreferencesFactory;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilePreferencesTest {
    private static final Logger LOGGER = LogManager.getLogger(FilePreferencesTest.class);

    @Test
    public void test() throws BackingStoreException {
        System.setProperty("java.util.prefs.PreferencesFactory", FilePreferencesFactory.class.getName());
        Prefs.setPrefsRootName((String)"cdc-prefs-test");
        LOGGER.info("preference file: {}", (Object)FilePreferencesFactory.getPreferencesFile());
        LOGGER.info("root name: {}", (Object)Prefs.getRootName());
        Preferences prefs = Prefs.getUserRoot();
        prefs.put("key1", "value");
        prefs.put("key2", "value");
        Assertions.assertEquals((Object)"value", (Object)prefs.get("key1", null));
        Assertions.assertEquals((Object)"value", (Object)prefs.get("key2", null));
        prefs.remove("key1");
        Assertions.assertEquals(null, (Object)prefs.get("key1", null));
        Assertions.assertEquals((Object)"value", (Object)prefs.get("key2", null));
        LOGGER.info("prefs: {}", (Object)prefs);
        for (String key : prefs.keys()) {
            LOGGER.info("key: {}", (Object)key);
        }
        for (String name : prefs.childrenNames()) {
            LOGGER.info("child: {}", (Object)name);
        }
    }
}

