/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.rids;

import cdc.informers.IdentifiableInformer;
import cdc.informers.StringConversionInformer;
import cdc.kernel.rids.RawId;
import cdc.util.encoding.Encoded;
import cdc.util.encoding.Encoders;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RawIdProxy
implements Comparable<RawIdProxy>,
Encoded<String> {
    private static final Logger LOGGER = LogManager.getLogger(RawIdProxy.class);
    public static final char SEPARATOR = ':';
    private final String code;

    public RawIdProxy(String objectClassCode, String idCode) {
        RawIdProxy.check(objectClassCode, idCode);
        this.code = objectClassCode + ':' + idCode;
    }

    public RawIdProxy(String code) {
        Checks.isNotNull((Object)code, (String)"code");
        int sep = code.indexOf(58);
        if (sep <= 0) {
            throw new IllegalArgumentException("RawIdProxy(" + code + ") failed, missing + " + ':');
        }
        String objectClassCode = code.substring(0, sep);
        String idCode = code.substring(sep + 1);
        RawIdProxy.check(objectClassCode, idCode);
        this.code = code;
    }

    public RawIdProxy(RawId rid) {
        this((String)Encoders.CLASS_CODE.encode(rid.getObjectClass(), FailureReaction.FAIL), RawIdProxy.encodeId(rid.getObjectClass(), rid.getId()));
    }

    private static void check(String objectClassCode, String idCode) {
        Checks.isTrue((boolean)RawIdProxy.isValidObjectClassCode(objectClassCode), (String)"Invalid object class code '{}'", (Object)objectClassCode);
        Checks.isTrue((boolean)RawIdProxy.isValidIdCode(idCode), (String)"Invalid id code '{}'", (Object)idCode);
        if (!RawIdProxy.isValidDecodableObjectClassCode(objectClassCode)) {
            LOGGER.warn("'{}' can not be decoded", (Object)objectClassCode);
        }
    }

    public static boolean isValidEncodableObjectClass(Class<?> objectClass) {
        return objectClass != null && Encoders.CLASS_CODE.canEncode(objectClass);
    }

    public static boolean isValidObjectClassCode(String objectClassCode) {
        return objectClassCode != null && !objectClassCode.isEmpty() && objectClassCode.indexOf(58) < 0;
    }

    public static boolean isValidDecodableObjectClassCode(String objectClassCode) {
        return objectClassCode != null && objectClassCode.indexOf(58) < 0 && Encoders.CLASS_CODE.canDecode((Object)objectClassCode);
    }

    public static boolean isValidIdCode(String idCode) {
        return idCode != null && idCode.length() > 0;
    }

    public static boolean areValidCreationArgs(String objectClassCode, String idCode) {
        return RawIdProxy.isValidDecodableObjectClassCode(objectClassCode) && RawIdProxy.isValidIdCode(idCode);
    }

    public String getObjectClassCode() {
        int sep = this.code.indexOf(58);
        return this.code.substring(0, sep);
    }

    public Class<?> getObjectClass() {
        return RawIdProxy.decodeObjectClass(this.getObjectClassCode());
    }

    public String getIdCode() {
        int sep = this.code.indexOf(58);
        return this.code.substring(sep + 1);
    }

    public static String encodeObjectClass(Class<?> objectClass) {
        return objectClass == null ? null : (String)Encoders.CLASS_CODE.encode(objectClass, FailureReaction.FAIL);
    }

    public static Class<?> decodeObjectClass(String objectClassCode) {
        return objectClassCode == null ? null : (Class)Encoders.CLASS_CODE.decode((Object)objectClassCode, FailureReaction.FAIL);
    }

    public static Object decodeId(Class<?> objectClass, String idCode) {
        return StringConversionInformer.Service.fromString((Class)IdentifiableInformer.Service.getIdClass(objectClass), (String)idCode);
    }

    public static String encodeId(Class<?> objectClass, Object id) {
        return StringConversionInformer.Service.toString((Object)id, (FailureReaction)FailureReaction.FAIL);
    }

    public Object getId() {
        return RawIdProxy.decodeId(this.getObjectClass(), this.getIdCode());
    }

    public RawId toRawId() {
        Class<?> objectClass = this.getObjectClass();
        Object id = RawIdProxy.decodeId(objectClass, this.getIdCode());
        String idCode2 = RawIdProxy.encodeId(objectClass, id);
        if (!this.getIdCode().equals(idCode2)) {
            LOGGER.warn("Encoding mismatch [{}] [{}]", (Object)this.getIdCode(), (Object)idCode2);
        }
        return new RawId(objectClass, id);
    }

    public static RawId toRawId(RawIdProxy ridp) {
        return ridp == null ? null : new RawId(ridp);
    }

    public static RawIdProxy fromRawId(RawId rid) {
        return rid == null ? null : new RawIdProxy(rid);
    }

    public String getCode() {
        return this.code;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RawIdProxy)) {
            return false;
        }
        RawIdProxy o = (RawIdProxy)object;
        return this.code.equals(o.code);
    }

    @Override
    public int compareTo(RawIdProxy o) {
        int cmp = this.getObjectClassCode().compareTo(o.getObjectClassCode());
        if (cmp == 0) {
            return this.getIdCode().compareTo(o.getIdCode());
        }
        return cmp;
    }

    public String toString() {
        return this.getCode();
    }
}

