/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.rids;

import cdc.kernel.rids.RawId;
import cdc.kernel.rids.RawIdProxy;
import cdc.kernel.rids.TestEnum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RawIdProxyTest {
    RawIdProxyTest() {
    }

    @Test
    void testConstructor() {
        RawIdProxy ridp1 = new RawIdProxy("TestEnum", "A");
        Assertions.assertEquals((Object)"TestEnum", (Object)ridp1.getObjectClassCode());
        Assertions.assertEquals((Object)"A", (Object)ridp1.getIdCode());
        Assertions.assertEquals((Object)"TestEnum:A", (Object)ridp1.getCode());
        Assertions.assertEquals((Object)ridp1, (Object)ridp1);
        Assertions.assertEquals(TestEnum.class, (Object)ridp1.getObjectClass());
        RawIdProxy ridp2 = new RawIdProxy("TestEnum:A");
        Assertions.assertEquals((Object)"TestEnum", (Object)ridp2.getObjectClassCode());
        Assertions.assertEquals((Object)"A", (Object)ridp2.getIdCode());
        Assertions.assertEquals((Object)"TestEnum:A", (Object)ridp2.getCode());
        Assertions.assertEquals((Object)((Object)TestEnum.A), (Object)ridp2.getId());
        Assertions.assertEquals((Object)ridp2, (Object)ridp2);
        Assertions.assertEquals((Object)ridp1, (Object)ridp2);
        Assertions.assertEquals((Object)ridp2, (Object)ridp1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RawIdProxy("Hello"));
        RawId rid = new RawId(TestEnum.class, (Object)TestEnum.A);
        RawIdProxy ridp3 = new RawIdProxy(rid);
        Assertions.assertEquals((Object)"TestEnum", (Object)ridp3.getObjectClassCode());
        Assertions.assertEquals((Object)"A", (Object)ridp3.getIdCode());
        Assertions.assertEquals((Object)"TestEnum:A", (Object)ridp3.getCode());
    }

    @Test
    void testToString() {
        RawIdProxy ridp1 = new RawIdProxy("TestEnum", "A");
        Assertions.assertEquals((Object)"TestEnum:A", (Object)ridp1.toString());
    }

    @Test
    void testEquals() {
        RawIdProxy ridp1 = new RawIdProxy("TestEnum", "A");
        RawIdProxy ridp2 = new RawIdProxy("TestEnum", "B");
        RawIdProxy ridp3 = new RawIdProxy("String", "A");
        RawIdProxy ridp4 = new RawIdProxy("String", "A");
        Assertions.assertEquals((Object)ridp1, (Object)ridp1);
        Assertions.assertNotEquals((Object)ridp1, (Object)ridp2);
        Assertions.assertNotEquals((Object)ridp1, (Object)ridp3);
        Assertions.assertNotEquals((Object)ridp1, (Object)"Hello");
        Assertions.assertEquals((Object)ridp3, (Object)ridp4);
    }

    @Test
    void testCompareTo() {
        RawIdProxy ridp1 = new RawIdProxy("TestEnum", "A");
        Assertions.assertSame((Object)ridp1.compareTo(ridp1), (Object)0);
        RawIdProxy ridp2 = new RawIdProxy("TestEnum", "B");
        Assertions.assertTrue((ridp1.compareTo(ridp2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ridp2.compareTo(ridp1) > 0 ? 1 : 0) != 0);
        RawIdProxy ridp3 = new RawIdProxy("String", "A");
        Assertions.assertTrue((ridp1.compareTo(ridp3) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ridp3.compareTo(ridp1) < 0 ? 1 : 0) != 0);
    }

    @Test
    void testCheckers() {
        TestEnum.elaborate();
        Assertions.assertTrue((boolean)RawIdProxy.isValidObjectClassCode((String)"X"));
        Assertions.assertFalse((boolean)RawIdProxy.isValidObjectClassCode((String)"X:A"));
        Assertions.assertFalse((boolean)RawIdProxy.isValidObjectClassCode((String)":"));
        Assertions.assertFalse((boolean)RawIdProxy.isValidObjectClassCode((String)""));
        Assertions.assertFalse((boolean)RawIdProxy.isValidObjectClassCode(null));
        Assertions.assertTrue((boolean)RawIdProxy.isValidDecodableObjectClassCode((String)"TestEnum"));
        Assertions.assertFalse((boolean)RawIdProxy.isValidDecodableObjectClassCode((String)"X"));
        Assertions.assertFalse((boolean)RawIdProxy.isValidDecodableObjectClassCode((String)""));
        Assertions.assertFalse((boolean)RawIdProxy.isValidDecodableObjectClassCode(null));
        Assertions.assertFalse((boolean)RawIdProxy.isValidDecodableObjectClassCode((String)"X:"));
        Assertions.assertFalse((boolean)RawIdProxy.isValidEncodableObjectClass(null));
        Assertions.assertFalse((boolean)RawIdProxy.isValidEncodableObjectClass(String.class));
        Assertions.assertTrue((boolean)RawIdProxy.isValidEncodableObjectClass(TestEnum.class));
        Assertions.assertTrue((boolean)RawIdProxy.isValidIdCode((String)"1"));
        Assertions.assertFalse((boolean)RawIdProxy.isValidIdCode((String)""));
        Assertions.assertFalse((boolean)RawIdProxy.isValidIdCode(null));
    }

    @Test
    void testMisc() {
        Assertions.assertEquals((Object)"A", (Object)RawIdProxy.encodeId(TestEnum.class, (Object)((Object)TestEnum.A)));
        Assertions.assertEquals(null, (Object)RawIdProxy.encodeId(TestEnum.class, null));
        Assertions.assertEquals((Object)((Object)TestEnum.A), (Object)RawIdProxy.decodeId(TestEnum.class, (String)"A"));
        Assertions.assertEquals(null, (Object)RawIdProxy.decodeId(TestEnum.class, null));
        Assertions.assertEquals((Object)"TestEnum", (Object)RawIdProxy.encodeObjectClass(TestEnum.class));
        Assertions.assertEquals(null, (Object)RawIdProxy.encodeObjectClass(null));
        Assertions.assertEquals(TestEnum.class, (Object)RawIdProxy.decodeObjectClass((String)"TestEnum"));
        Assertions.assertEquals(null, (Object)RawIdProxy.decodeObjectClass(null));
    }

    @Test
    void testConverters() {
        RawIdProxy ridp1 = new RawIdProxy("TestEnum", "A");
        RawId rid1 = new RawId(TestEnum.class, (Object)TestEnum.A);
        Assertions.assertEquals((Object)rid1, (Object)RawIdProxy.toRawId((RawIdProxy)ridp1));
        Assertions.assertEquals((Object)rid1, (Object)ridp1.toRawId());
        Assertions.assertEquals(null, (Object)RawIdProxy.toRawId(null));
        Assertions.assertEquals((Object)ridp1, (Object)RawIdProxy.fromRawId((RawId)rid1));
        Assertions.assertEquals(null, (Object)RawIdProxy.fromRawId(null));
    }
}

