/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.rids;

import cdc.kernel.rids.RawId;
import cdc.kernel.rids.RawIdProxy;
import cdc.kernel.rids.TestEnum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RawIdTest {
    RawIdTest() {
    }

    @Test
    void testNullId() {
        RawId rid1 = new RawId(Object.class, null);
        RawId rid2 = new RawId(Object.class, null);
        Assertions.assertEquals(null, (Object)rid1.getId());
        Assertions.assertEquals(Object.class, (Object)rid1.getObjectClass());
        Assertions.assertEquals((Object)rid1, (Object)rid1);
        Assertions.assertEquals((Object)rid1, (Object)rid2);
        Assertions.assertEquals((int)0, (int)rid1.compareTo(rid2));
        RawId rid3 = new RawId(String.class, null);
        Assertions.assertNotEquals((Object)rid1, (Object)rid3);
        Assertions.assertNotSame((Object)rid1.compareTo(rid3), (Object)0);
    }

    @Test
    void testCompare() {
        RawId rid1 = new RawId(Object.class, null);
        RawId rid2 = new RawId(Object.class, (Object)0);
        RawId rid3 = new RawId(Object.class, (Object)1);
        RawId rid4 = new RawId(Integer.class, (Object)10);
        RawId rid5 = new RawId(String.class, (Object)"Hello");
        RawId rid6 = new RawId(Object.class, new Object());
        RawId rid7 = new RawId(Object.class, new Object());
        Assertions.assertEquals((Object)1, (Object)rid3.getId());
        Assertions.assertEquals((int)1, (Integer)((Integer)rid3.getId(Integer.class)));
        Assertions.assertSame((Object)0, (Object)rid1.compareTo(rid1));
        Assertions.assertTrue((rid1.compareTo(rid2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((rid2.compareTo(rid1) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((rid2.compareTo(rid3) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((rid3.compareTo(rid2) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((rid4.compareTo(rid3) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((rid4.compareTo(rid5) < 0 ? 1 : 0) != 0);
        Assertions.assertNotSame((Object)0, (Object)rid6.compareTo(rid7));
    }

    @Test
    void testToString() {
        RawId rid1 = new RawId(Object.class, null);
        Assertions.assertEquals((Object)"[java.lang.Object:null]", (Object)rid1.toString());
        RawId rid2 = new RawId(Integer.class, (Object)0);
        Assertions.assertEquals((Object)"[java.lang.Integer:0]", (Object)rid2.toString());
    }

    @Test
    void testConverters() {
        RawIdProxy ridp1 = new RawIdProxy("TestEnum", "A");
        RawId rid1 = new RawId(TestEnum.class, (Object)TestEnum.A);
        Assertions.assertEquals((Object)ridp1, (Object)RawId.toRawIdProxy((RawId)rid1));
        Assertions.assertEquals(null, (Object)RawId.toRawIdProxy(null));
        Assertions.assertEquals((Object)rid1, (Object)RawId.fromRawIdProxy((RawIdProxy)ridp1));
        Assertions.assertEquals(null, (Object)RawId.fromRawIdProxy(null));
    }

    @Test
    void testMisc() {
        RawId rid1 = new RawId(TestEnum.class, (Object)TestEnum.A);
        Assertions.assertEquals((Object)"TestEnum", (Object)rid1.getObjectClassCode());
        Assertions.assertEquals((Object)"A", (Object)rid1.getIdCode());
    }
}

