/*
 * Decompiled with CFR 0.152.
 */
package cdc.kernel.rids;

import cdc.kernel.rids.RawIdProxy;
import cdc.util.lang.Checks;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RawId
implements Comparable<RawId> {
    private static final Logger LOGGER = LogManager.getLogger(RawId.class);
    private final Class<?> objectClass;
    private final Object id;

    public RawId(Class<?> objectClass, Object id) {
        Checks.isNotNull(objectClass, (String)"objectClass");
        this.objectClass = objectClass;
        this.id = id;
        if (!RawIdProxy.isValidEncodableObjectClass(objectClass)) {
            LOGGER.warn("{} can not be encoded", objectClass);
        }
    }

    public RawId(RawIdProxy ridp) {
        this(ridp.getObjectClass(), ridp.getId());
    }

    public static RawId create(Class<?> objectClass, Object id) {
        return new RawId(objectClass, id);
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassCode() {
        return RawIdProxy.encodeObjectClass(this.objectClass);
    }

    public Object getId() {
        return this.id;
    }

    public <T> T getId(Class<T> type) {
        return type.cast(this.id);
    }

    public String getIdCode() {
        return RawIdProxy.encodeId(this.objectClass, this.id);
    }

    private String safeEncodeId() {
        try {
            String s = this.getIdCode();
            return s == null ? Objects.toString(this.id) : s;
        }
        catch (Exception e) {
            return Objects.toString(this.id);
        }
    }

    public int hashCode() {
        return Objects.hash(this.objectClass, this.id);
    }

    public static RawIdProxy toRawIdProxy(RawId rid) {
        return rid == null ? null : new RawIdProxy(rid);
    }

    public static RawId fromRawIdProxy(RawIdProxy ridp) {
        return ridp == null ? null : ridp.toRawId();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RawId)) {
            return false;
        }
        RawId o = (RawId)object;
        return this.objectClass.equals(o.objectClass) && Objects.equals(this.id, o.id);
    }

    @Override
    public int compareTo(RawId o) {
        int objectClassCmp = this.objectClass.getCanonicalName().compareTo(o.objectClass.getCanonicalName());
        if (objectClassCmp == 0) {
            if (this.id == o.id) {
                return 0;
            }
            if (this.id == null) {
                return -1;
            }
            if (o.id == null) {
                return 1;
            }
            if (this.id.getClass() == o.id.getClass() && Comparable.class.isAssignableFrom(this.id.getClass())) {
                Comparable cid = (Comparable)this.id;
                return cid.compareTo(o.id);
            }
            String eid = this.safeEncodeId();
            String eoid = o.safeEncodeId();
            return eid.compareTo(eoid);
        }
        return objectClassCmp;
    }

    public String toString() {
        return "[" + this.objectClass.getCanonicalName() + ":" + String.valueOf(this.id) + "]";
    }
}

