/*
 * Decompiled with CFR 0.152.
 */
package cdc.pstrings;

import cdc.pstrings.PackedString;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PackedStringTest {
    private static final Logger LOGGER = LogManager.getLogger(PackedStringTest.class);

    PackedStringTest() {
    }

    private static String build(String s, int count) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < count; ++index) {
            builder.append(s);
        }
        return builder.toString();
    }

    private static void checkConvert(String s) {
        LOGGER.debug("s: '" + s + "' " + (s == null ? "" : Integer.valueOf(s.length())));
        Object o1 = PackedString.convert((String)s);
        if (s == null) {
            Assertions.assertEquals(null, (Object)o1);
        } else {
            String s2 = o1.toString();
            Assertions.assertEquals((Object)s, (Object)s2);
        }
        Object o2 = PackedString.convert((String)s);
        Assertions.assertEquals((Object)o1, (Object)o2);
        if (o1 != null && o2 != null) {
            Assertions.assertEquals((int)o1.hashCode(), (int)o2.hashCode());
        }
    }

    private static void checkConvert(int n) {
        LOGGER.debug("c: [" + n + "] " + Character.charCount(n) + " '" + Character.getName(n) + "'");
        char c = (char)n;
        if (!Character.isSurrogate(c)) {
            String s = Character.toString(c);
            Object o1 = PackedString.convert((String)s);
            Object o2 = PackedString.convert((String)s, (boolean)true);
            Object o3 = PackedString.convert((String)s, (boolean)false);
            String s1p = o1.toString();
            String s2p = o2.toString();
            String s3p = o3.toString();
            Assertions.assertEquals((Object)s, (Object)s1p);
            Assertions.assertEquals((Object)s, (Object)s2p);
            Assertions.assertEquals((Object)s, (Object)s3p);
        }
    }

    @Test
    void checkConvert() {
        int i;
        PackedStringTest.checkConvert(null);
        PackedStringTest.checkConvert("");
        PackedStringTest.checkConvert("a");
        PackedStringTest.checkConvert("\u00e0");
        for (i = 0; i < 128; ++i) {
            PackedStringTest.checkConvert(PackedStringTest.build("a", i));
            PackedStringTest.checkConvert(PackedStringTest.build("\u00e0", i));
        }
        for (i = 0; i <= 0x10FFFF; ++i) {
            PackedStringTest.checkConvert(i);
        }
    }

    @Test
    void checkEquals() {
        int i1;
        ArrayList<String> s = new ArrayList<String>();
        ArrayList<Object> ps = new ArrayList<Object>();
        for (i1 = 0; i1 < 70; ++i1) {
            for (int k = 0; k <= i1; ++k) {
                StringBuilder builder = new StringBuilder();
                for (int i2 = 0; i2 < i1; ++i2) {
                    if (k == i2) {
                        builder.append('1');
                        continue;
                    }
                    builder.append('0');
                }
                String x = builder.toString();
                s.add(x);
                ps.add(PackedString.convert((String)x));
            }
        }
        for (i1 = 0; i1 < s.size(); ++i1) {
            for (int i2 = 0; i2 < s.size(); ++i2) {
                Assertions.assertSame((Object)((String)s.get(i1)).equals(s.get(i2)), (Object)ps.get(i1).equals(ps.get(i2)));
            }
        }
    }

    @Test
    void checkIntern() {
        Assertions.assertSame(null, (Object)PackedString.intern(null));
        Assertions.assertEquals((Object)"Hello", (Object)PackedString.intern((Object)"Hello"));
        Assertions.assertEquals((Object)PackedString.convert((String)"Hello"), (Object)PackedString.intern((Object)PackedString.convert((String)"Hello")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PackedString.intern((Object)Character.valueOf('A')));
    }
}

