/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.args;

import cdc.util.args.Args;
import cdc.util.args.Factory;
import cdc.util.args.FormalArgs;
import cdc.util.lang.Checks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractFactory<T>
implements Factory<T> {
    private final Class<T> objectClass;
    private final List<FormalArgs> creationFormalArgs;
    private final Args meta;

    protected AbstractFactory(Class<T> objectClass, Args meta, List<FormalArgs> creationFormalArgs) {
        Checks.isNotNull(objectClass, (String)"objectClass");
        Checks.isNotNull((Object)meta, (String)"meta");
        Checks.isNotNullOrEmpty(creationFormalArgs, (String)"creationFormalArgs");
        this.objectClass = objectClass;
        this.creationFormalArgs = Collections.unmodifiableList(creationFormalArgs);
        this.meta = meta;
    }

    protected AbstractFactory(Class<T> objectClass, List<FormalArgs> creationFormalArgs) {
        this(objectClass, Args.NO_ARGS, creationFormalArgs);
    }

    protected AbstractFactory(Class<T> objectClass, Args meta, FormalArgs ... creationFormalArgs) {
        this(objectClass, meta, Arrays.asList(creationFormalArgs));
    }

    protected AbstractFactory(Class<T> objectClass, FormalArgs ... creationFormalArgs) {
        this(objectClass, Args.NO_ARGS, creationFormalArgs);
    }

    protected AbstractFactory(Class<T> objectClass, Args meta) {
        this(objectClass, meta, FormalArgs.DEFAULT_FARGS_LIST);
    }

    protected AbstractFactory(Class<T> objectClass) {
        this(objectClass, Args.NO_ARGS);
    }

    @Override
    public final Class<T> getObjectClass() {
        return this.objectClass;
    }

    @Override
    public final Args getMeta() {
        return this.meta;
    }

    @Override
    public final List<FormalArgs> getCreationFormalArgsList() {
        return this.creationFormalArgs;
    }

    protected abstract T create(Args var1, FormalArgs var2);

    @Override
    public final T create(Args args) {
        List<FormalArgs> clist = this.getCreationFormalArgsList();
        if (clist.isEmpty() || clist.size() == 1 && clist.get(0).equals(FormalArgs.NO_FARGS)) {
            return this.create(args, FormalArgs.NO_FARGS);
        }
        for (FormalArgs fargs : this.getCreationFormalArgsList()) {
            if (!args.isLooselyCompliantWith(fargs)) continue;
            return this.create(args, fargs);
        }
        throw new IllegalArgumentException(args + " is not loosely compliant with one of " + this.getCreationFormalArgsList());
    }

    public String toString() {
        return "Factory<" + this.getObjectClass().getCanonicalName() + ">" + this.getMeta();
    }
}

