/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.args;

import cdc.util.args.Arg;
import cdc.util.args.Args;
import cdc.util.args.Factories;
import cdc.util.args.Factory;
import cdc.util.data.Child;
import cdc.util.data.Element;
import cdc.util.data.util.AbstractResourceLoader;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import cdc.util.xml.AbstractStAXLoader;
import cdc.util.xml.AbstractStAXParser;
import cdc.util.xml.XmlWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class ArgsIo {
    public static final String ARG = "arg";
    public static final String ARGS = "args";
    public static final String CLASS = "class";
    public static final String FACTORIES = "factories";
    public static final String FACTORY = "factory";
    public static final String INSTANCE = "instance";
    public static final String NAME = "name";
    public static final String VALUE = "value";

    private ArgsIo() {
    }

    public static void write(XmlWriter writer, Args args, boolean convert) throws IOException {
        if (!args.isEmpty()) {
            writer.beginElement(ARGS);
            for (Arg arg : args.getArgs()) {
                ArgsIo.write(writer, arg, convert);
            }
            writer.endElement();
        }
    }

    public static void write(XmlWriter writer, Arg arg, boolean convert) throws IOException {
        if (arg.getValue() == null) {
            writer.beginElement(ARG);
            writer.addAttribute(NAME, arg.getName());
            writer.endElement();
        } else {
            Arg tmp = convert ? Factories.convertToStringValues(arg) : arg;
            writer.beginElement(ARG);
            writer.addAttribute(NAME, tmp.getName());
            if (tmp.getValue() != null) {
                writer.addAttribute(VALUE, tmp.getValue());
            }
            writer.endElement();
        }
    }

    public static Element toElement(Args args, boolean convert) {
        if (!args.isEmpty()) {
            Element element = new Element(ARGS);
            for (Arg arg : args.getArgs()) {
                element.addChild((Child)ArgsIo.toElement(arg, convert));
            }
            return element;
        }
        return null;
    }

    public static Element toElement(Arg arg, boolean convert) {
        Element element = new Element(ARG);
        element.addAttribute(NAME, arg.getName());
        if (arg.getValue() != null) {
            Arg tmp;
            Arg arg2 = tmp = convert ? Factories.convertToStringValues(arg) : arg;
            if (tmp.getValue() != null) {
                element.addAttribute(VALUE, tmp.getValue());
            }
        }
        return element;
    }

    public static class StAXLoader
    extends AbstractStAXLoader<Void> {
        public StAXLoader(FailureReaction reaction) {
            super(reader -> new Parser((XMLStreamReader)reader, reaction));
        }

        private static class Parser
        extends AbstractStAXParser<Void> {
            protected Parser(XMLStreamReader reader, FailureReaction reaction) {
                super(reader, reaction);
            }

            protected Void parse() throws XMLStreamException {
                this.nextTag();
                if (this.isStartElement(ArgsIo.FACTORIES)) {
                    this.parseFactories();
                    this.next();
                    this.expectEndDocument("parse()");
                    return null;
                }
                throw this.unexpectedEvent();
            }

            private void parseFactories() throws XMLStreamException {
                this.nextTag();
                while (this.reader.isStartElement()) {
                    this.expectStartElement("parseFactories()", ArgsIo.FACTORY);
                    if (!this.isStartElement(ArgsIo.FACTORY)) {
                        throw this.unexpectedEvent();
                    }
                    this.parseAndRegisterFactory();
                    this.nextTag();
                }
            }

            private void parseAndRegisterFactory() throws XMLStreamException {
                Factory<?> factory = this.parseFactory();
                if (factory != null) {
                    if (Factories.getClasses().contains(factory.getObjectClass())) {
                        this.onError("A '" + factory.getObjectClass().getCanonicalName() + "' factory is already registered");
                    } else {
                        Factories.register(factory);
                    }
                }
            }

            private Factory<?> parseFactory() throws XMLStreamException {
                this.expectStartElement("parseFactory()", ArgsIo.FACTORY);
                String className = this.getAttributeValue(ArgsIo.CLASS, null);
                String instanceName = this.getAttributeValue(ArgsIo.INSTANCE, null);
                Factory factory = null;
                if (className == null && instanceName == null || className != null && instanceName != null) {
                    factory = (Factory)this.onError("one of class or instance attribute must be set", null);
                } else if (className != null) {
                    Class cls = Introspection.getClass((String)className, (FailureReaction)this.getReaction());
                    if (cls != null) {
                        try {
                            factory = (Factory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            factory = (Factory)this.onError("Failed to instantiate '" + className + "'", null);
                        }
                    }
                } else {
                    factory = (Factory)this.onError("instance support not yet implemented", null);
                }
                this.nextTag();
                this.expectEndElement("parseFactory()", ArgsIo.FACTORY);
                return factory;
            }
        }
    }

    public static class ArgsParser
    extends AbstractStAXParser<Void> {
        public ArgsParser(XMLStreamReader reader, FailureReaction reaction) {
            super(reader, reaction);
        }

        protected Void parse() {
            throw new UnsupportedOperationException();
        }

        public Args parseArgs() throws XMLStreamException {
            this.expectStartElement("parseArgs()", ArgsIo.ARGS);
            Args.Builder builder = Args.builder();
            this.nextTag();
            while (this.isStartElement(ArgsIo.ARG)) {
                String argName = this.getAttributeValue(ArgsIo.NAME, null);
                String argValue = this.getAttributeValue(ArgsIo.VALUE, null);
                builder.setArg(argName, argValue);
                this.nextTag();
                this.expectEndElement("parseArgs()", ArgsIo.ARG);
                this.nextTag();
            }
            this.expectEndElement("parseArgs()", ArgsIo.ARGS);
            return builder.build();
        }
    }

    public static class DataLoader
    extends AbstractResourceLoader<Void> {
        public DataLoader(FailureReaction reaction) {
            super(reaction);
        }

        protected Void loadRoot(Element root) {
            this.loadAndRegisterFactories(root);
            return null;
        }

        public void loadAndRegisterFactories(Element element) {
            if (element.getName().equals(ArgsIo.FACTORIES)) {
                for (Element child : element.getElements()) {
                    if (child.getName().equals(ArgsIo.FACTORY)) {
                        this.loadAndRegisterFactory(child);
                        continue;
                    }
                    this.unexpectedElement(child, new String[]{ArgsIo.FACTORY});
                }
            } else {
                this.unexpectedElement(element, new String[]{ArgsIo.FACTORIES});
            }
        }

        public void loadAndRegisterFactory(Element element) {
            Factory<?> factory = this.loadFactory(element);
            if (factory != null) {
                if (Factories.getClasses().contains(factory.getObjectClass())) {
                    this.onError("A '" + factory.getObjectClass().getCanonicalName() + "' factory is already registered");
                } else {
                    Factories.register(factory);
                }
            }
        }

        public Factory<?> loadFactory(Element element) {
            if (element.getName().equals(ArgsIo.FACTORY)) {
                String className = element.getAttributeValue(ArgsIo.CLASS, null);
                String instanceName = element.getAttributeValue(ArgsIo.INSTANCE, null);
                if (className == null && instanceName == null || className != null && instanceName != null) {
                    return (Factory)this.onError("one of class or instance attribute must be set", null);
                }
                if (className != null) {
                    Class cls = Introspection.getClass((String)className, (FailureReaction)this.getReaction());
                    if (cls != null) {
                        try {
                            return (Factory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            return (Factory)this.onError("Failed to instantiate '" + className + "'", null);
                        }
                    }
                    return null;
                }
                return (Factory)this.onError("instance support not yet implemented", null);
            }
            return (Factory)this.unexpectedElement(element, null, new String[]{ArgsIo.FACTORY});
        }

        public Args loadArgs(Element element) {
            if (element.getName().equals(ArgsIo.ARGS)) {
                Args.Builder builder = Args.builder();
                for (Element child : element.getElements()) {
                    if (child.getName().equals(ArgsIo.ARG)) {
                        String argName = child.getAttributeValue(ArgsIo.NAME, null);
                        String argValue = child.getAttributeValue(ArgsIo.VALUE, null);
                        builder.setArg(argName, argValue);
                        continue;
                    }
                    this.unexpectedElement(child, new String[]{ArgsIo.ARG});
                }
                return builder.build();
            }
            return (Args)this.unexpectedElement(element, Args.NO_ARGS, new String[]{ArgsIo.ARGS});
        }

        public static Args toArgsLoose(Element element) {
            Args.Builder builder = Args.builder();
            for (Element child : element.getElements()) {
                if (!child.getName().equals(ArgsIo.ARG)) continue;
                String argName = child.getAttributeValue(ArgsIo.NAME, null);
                String argValue = child.getAttributeValue(ArgsIo.VALUE, null);
                builder.setArg(argName, argValue);
            }
            return builder.build();
        }

        public Args loadOptionalChildArgs(Element parent) {
            if (parent.hasChildren(Element.class, Element.named((String)ArgsIo.ARGS))) {
                return this.loadArgs((Element)parent.getChildAt(Element.class, Element.named((String)ArgsIo.ARGS), 0));
            }
            return Args.NO_ARGS;
        }
    }
}

