/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.args;

import cdc.util.args.AbstractFactory;
import cdc.util.args.Args;
import cdc.util.args.FormalArgs;
import cdc.util.lang.IllegalCallException;
import cdc.util.lang.Introspection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoFactory<T>
extends AbstractFactory<T> {
    private static final Logger LOGGER = LogManager.getLogger(AutoFactory.class);
    private final Field instance;
    private final Constructor<T> ctor;

    public AutoFactory(Class<T> objectClass) {
        super(objectClass);
        this.instance = AutoFactory.getInstanceField(objectClass);
        this.ctor = Introspection.getConstructor(objectClass, (Class[])new Class[0]);
        if (this.instance == null && this.ctor == null) {
            throw new IllegalArgumentException("Can not create auto factory for " + objectClass.getCanonicalName());
        }
        if (this.instance != null) {
            LOGGER.debug("Found instance " + this.instance + " for " + objectClass.getCanonicalName());
        } else {
            LOGGER.debug("Found constructor " + this.ctor + " for " + objectClass.getCanonicalName());
        }
    }

    @Override
    protected T create(Args args, FormalArgs fargs) {
        try {
            if (this.instance != null) {
                return this.getObjectClass().cast(this.instance.get(null));
            }
            return this.ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalCallException("Failed to create a " + this.getObjectClass().getCanonicalName() + " instance", (Throwable)e);
        }
    }

    private static Field getInstanceField(Class<?> cls) {
        Set fields = Introspection.getFieldsMatching(cls, f -> Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && f.getType().equals(cls));
        if (fields.size() == 1) {
            return (Field)fields.iterator().next();
        }
        return null;
    }
}

