/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.args;

import cdc.util.args.FormalArg;
import cdc.util.args.Necessity;
import cdc.util.lang.Introspection;
import java.util.Map;

public class MapFormalArg<K, V>
extends FormalArg<Map<K, V>> {
    private final Class<K> keyType;
    private final Class<V> valueType;

    public MapFormalArg(String name, Class<K> keyType, Class<V> valueType, Necessity necessity) {
        super(name, Introspection.uncheckedCast(Map.class), necessity);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public MapFormalArg(String name, Class<K> keyType, Class<V> valueType) {
        this(name, keyType, valueType, Necessity.MANDATORY);
    }

    public final Class<K> getKeyType() {
        return this.keyType;
    }

    public final Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * (this.keyType.hashCode() + 31 * this.valueType.hashCode());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapFormalArg)) {
            return false;
        }
        MapFormalArg o = (MapFormalArg)other;
        return super.equals(other) && this.keyType.equals(o.keyType) && this.valueType.equals(o.valueType);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getName());
        builder.append(" => ");
        builder.append(this.getType().getSimpleName());
        builder.append("<");
        builder.append(this.getKeyType().getSimpleName());
        builder.append(", ");
        builder.append(this.getValueType().getSimpleName());
        builder.append("> ");
        builder.append((Object)this.getNecessity());
        builder.append("]");
        return builder.toString();
    }
}

