/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.args;

import cdc.util.args.Args;
import cdc.util.args.Factory;
import cdc.util.args.FormalArgs;
import cdc.util.lang.Checks;
import java.util.List;

public class Singleton<T>
implements Factory<T> {
    private final Class<T> objectClass;
    private final T object;
    private final Args meta;

    public Singleton(Class<T> objectClass, T object, Args meta) {
        Checks.isNotNull(objectClass, (String)"objectClass");
        Checks.isNotNull((Object)meta, (String)"meta");
        this.objectClass = objectClass;
        this.object = object;
        this.meta = meta;
    }

    public Singleton(T object, Args meta) {
        Checks.isNotNull(object, (String)"object");
        Checks.isNotNull((Object)meta, (String)"meta");
        Class<?> tmp = object.getClass();
        this.objectClass = tmp;
        this.object = object;
        this.meta = meta;
    }

    @Override
    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    @Override
    public Args getMeta() {
        return this.meta;
    }

    @Override
    public List<FormalArgs> getCreationFormalArgsList() {
        return FormalArgs.DEFAULT_FARGS_LIST;
    }

    @Override
    public T create(Args args) {
        return this.object;
    }
}

