/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv;

import cdc.util.csv.CsvParser;
import cdc.util.function.Evaluation;
import cdc.util.lang.ImplementationException;
import cdc.util.tables.Row;
import cdc.util.tables.RowLocation;
import cdc.util.tables.TableAdapter;
import cdc.util.tables.TableHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CsvLoader {
    private static final Logger LOGGER = LogManager.getLogger(CsvLoader.class);

    private CsvLoader() {
    }

    public static List<Row> load(File file, String charset, char separator) throws IOException {
        LOGGER.info("load(" + file + ", " + charset + ", " + separator + ")");
        CsvParser parser = new CsvParser(separator);
        Handler handler = new Handler();
        try {
            parser.parse(file, charset, (TableHandler)handler, 0);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImplementationException((Throwable)e);
        }
        return handler.rows;
    }

    private static class Handler
    extends TableAdapter {
        final List<Row> rows = new ArrayList<Row>();

        public Evaluation processHeader(Row header, RowLocation location) {
            this.rows.add(header);
            return Evaluation.CONTINUE;
        }

        public Evaluation processData(Row data, RowLocation location) throws Exception {
            this.rows.add(data);
            return Evaluation.CONTINUE;
        }
    }
}

