/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv;

import cdc.util.csv.InvalidStateException;
import cdc.util.function.Evaluation;
import cdc.util.lang.Checks;
import cdc.util.lang.ImplementationException;
import cdc.util.tables.Row;
import cdc.util.tables.RowLocation;
import cdc.util.tables.RowLocationImpl;
import cdc.util.tables.TableHandler;
import cdc.util.txt.LineParser;
import cdc.util.txt.LinesHandler;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CsvParser {
    private static final Logger LOGGER = LogManager.getLogger(CsvParser.class);
    char separator;
    private boolean verbose = false;

    public CsvParser() {
        this.separator = (char)59;
    }

    public CsvParser(char separator) {
        this.separator = separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void parse(Reader reader, TableHandler handler, boolean hasHeader) throws Exception {
        LineParser.parse((Reader)reader, (LinesHandler)new Handler(handler, hasHeader));
    }

    public void parse(InputStream in, String charset, TableHandler handler, boolean hasHeader) throws Exception {
        LineParser.parse((InputStream)in, (String)charset, (LinesHandler)new Handler(handler, hasHeader));
    }

    public void parse(InputStream in, TableHandler handler, boolean hasHeader) throws Exception {
        LineParser.parse((InputStream)in, (LinesHandler)new Handler(handler, hasHeader));
    }

    public void parse(Reader reader, TableHandler handler, int headers) throws Exception {
        LineParser.parse((Reader)reader, (LinesHandler)new Handler(handler, headers));
    }

    public void parse(InputStream in, String charset, TableHandler handler, int headers) throws Exception {
        LineParser.parse((InputStream)in, (String)charset, (LinesHandler)new Handler(handler, headers));
    }

    public void parse(InputStream in, TableHandler handler, int headers) throws Exception {
        LineParser.parse((InputStream)in, (LinesHandler)new Handler(handler, headers));
    }

    private void traceBegin(Object object) {
        if (this.verbose) {
            LOGGER.info("Load: '" + object + "' ... ");
        }
    }

    private void traceEnd() {
        if (this.verbose) {
            LOGGER.info("Done");
        }
    }

    public void parse(String filename, String charset, TableHandler handler, boolean hasHeader) throws Exception {
        this.traceBegin(filename);
        LineParser.parse((String)filename, (String)charset, (LinesHandler)new Handler(handler, hasHeader));
        this.traceEnd();
    }

    public void parse(String filename, TableHandler handler, boolean hasHeader) throws Exception {
        this.traceBegin(filename);
        LineParser.parse((String)filename, (LinesHandler)new Handler(handler, hasHeader));
        this.traceEnd();
    }

    public void parse(String filename, TableHandler handler, int headers) throws Exception {
        this.traceBegin(filename);
        LineParser.parse((String)filename, (LinesHandler)new Handler(handler, headers));
        this.traceEnd();
    }

    public void parse(File file, String charset, TableHandler handler, boolean hasHeader) throws Exception {
        this.traceBegin(file);
        LineParser.parse((File)file, (String)charset, (LinesHandler)new Handler(handler, hasHeader));
        this.traceEnd();
    }

    public void parse(File file, String charset, TableHandler handler, int headers) throws Exception {
        this.traceBegin(file);
        LineParser.parse((File)file, (String)charset, (LinesHandler)new Handler(handler, headers));
        this.traceEnd();
    }

    public void parse(File file, TableHandler handler, boolean hasHeader) throws Exception {
        this.traceBegin(file);
        LineParser.parse((File)file, (LinesHandler)new Handler(handler, hasHeader));
        this.traceEnd();
    }

    private class Handler
    implements LinesHandler {
        private final TableHandler tableHandler;
        private final int headers;
        private Status currentStatus = Status.LINE_OUT;
        private final StringBuilder currentValue = new StringBuilder();
        private final Row.Builder output = Row.builder();
        private final RowLocationImpl location = new RowLocationImpl();
        private int globalNumber = 0;
        private Evaluation evaluation = Evaluation.CONTINUE;

        Handler(TableHandler handler, int headers) {
            Checks.isNotNull((Object)handler, (String)"handler");
            Checks.isTrue((headers >= 0 ? 1 : 0) != 0, (String)"invalid headers");
            this.tableHandler = handler;
            this.headers = headers;
        }

        Handler(TableHandler handler, boolean hasHeader) {
            this(handler, hasHeader ? 1 : 0);
        }

        private void implementationError() {
            throw new ImplementationException("unhandled status: " + (Object)((Object)this.currentStatus));
        }

        public void processBegin() throws Exception {
            this.output.clear();
            this.tableHandler.processBegin();
            this.location.startHeader();
        }

        public void processEnd() throws Exception {
            switch (this.currentStatus) {
                case FIELD_IN_QUOTE: 
                case FIELD_IN_SPEC: 
                case FIELD_IN_STD: {
                    throw new InvalidStateException("Invalid status (" + (Object)((Object)this.currentStatus) + ") at the end of parsing.");
                }
                case FIELD_OUT: 
                case LINE_OUT: {
                    break;
                }
                default: {
                    this.implementationError();
                }
            }
            this.tableHandler.processEnd();
        }

        public Evaluation processLine(String line, int number) throws Exception {
            block20: for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '\"') {
                    switch (this.currentStatus) {
                        case FIELD_OUT: 
                        case LINE_OUT: {
                            this.setStatus(Status.FIELD_IN_SPEC);
                            break;
                        }
                        case FIELD_IN_STD: {
                            this.appendChar(c);
                            break;
                        }
                        case FIELD_IN_SPEC: {
                            this.setStatus(Status.FIELD_IN_QUOTE);
                            break;
                        }
                        case FIELD_IN_QUOTE: {
                            this.appendChar('\"');
                            this.setStatus(Status.FIELD_IN_SPEC);
                            break;
                        }
                        default: {
                            this.implementationError();
                            break;
                        }
                    }
                    continue;
                }
                if (c == CsvParser.this.separator) {
                    switch (this.currentStatus) {
                        case FIELD_IN_QUOTE: 
                        case FIELD_IN_STD: 
                        case FIELD_OUT: 
                        case LINE_OUT: {
                            this.addValue();
                            break;
                        }
                        case FIELD_IN_SPEC: {
                            this.appendChar(c);
                            break;
                        }
                        default: {
                            this.implementationError();
                            break;
                        }
                    }
                    continue;
                }
                switch (this.currentStatus) {
                    case FIELD_OUT: 
                    case LINE_OUT: {
                        this.appendChar(c);
                        this.setStatus(Status.FIELD_IN_STD);
                        continue block20;
                    }
                    case FIELD_IN_SPEC: 
                    case FIELD_IN_STD: {
                        this.appendChar(c);
                        continue block20;
                    }
                    case FIELD_IN_QUOTE: {
                        this.appendChar(c);
                        this.setStatus(Status.FIELD_IN_SPEC);
                        continue block20;
                    }
                    default: {
                        this.implementationError();
                    }
                }
            }
            switch (this.currentStatus) {
                case FIELD_IN_QUOTE: 
                case FIELD_IN_STD: 
                case FIELD_OUT: {
                    this.addValue();
                    this.flushLineIfAny();
                    break;
                }
                case FIELD_IN_SPEC: {
                    this.appendNewLine();
                    break;
                }
                case LINE_OUT: {
                    this.flushLineIfAny();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this.evaluation;
        }

        private void setStatus(Status status) {
            this.currentStatus = status;
        }

        private void appendChar(char c) {
            this.currentValue.append(c);
        }

        private void appendNewLine() {
            this.currentValue.append('\n');
        }

        private void addValue() {
            this.output.addValue(this.currentValue.toString());
            this.currentValue.setLength(0);
            this.setStatus(Status.FIELD_OUT);
        }

        private void flushLineIfAny() throws Exception {
            this.location.incrementNumbers();
            if (this.globalNumber <= this.headers) {
                this.evaluation = this.tableHandler.processHeader(this.output.build(), (RowLocation)this.location);
                if (this.globalNumber == this.headers) {
                    this.location.startData();
                }
            } else {
                this.evaluation = this.tableHandler.processData(this.output.build(), (RowLocation)this.location);
            }
            ++this.globalNumber;
            this.output.clear();
            this.currentValue.setLength(0);
            this.setStatus(Status.LINE_OUT);
        }
    }

    private static enum Status {
        LINE_OUT,
        FIELD_IN_STD,
        FIELD_IN_SPEC,
        FIELD_IN_QUOTE,
        FIELD_OUT;

    }
}

