/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.csv;

import cdc.util.csv.CsvParser;
import cdc.util.function.Evaluation;
import cdc.util.tables.Row;
import cdc.util.tables.RowImpl;
import cdc.util.tables.TableHandler;
import cdc.util.tools.FileEncoder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class CsvParserTest {
    protected static final Logger LOGGER = LogManager.getLogger(CsvParserTest.class);
    private static final char SEPARATOR = ';';
    private final List<Row> rows = new ArrayList<Row>();
    private final File filePlatform = new File("target", this.getClass().getSimpleName() + "-platform.txt");
    private final File fileUtf8 = new File("target", this.getClass().getSimpleName() + "-utf8.txt");
    private final File fileUtf16 = new File("target", this.getClass().getSimpleName() + "-utf16.txt");

    public CsvParserTest() throws IOException {
        this.rows.add((Row)new RowImpl().setNumber(0).addValue("V1").addValue("V2"));
        this.rows.add((Row)new RowImpl().setNumber(1).addValue("Aaaa").addValue("\u00e0\u00e0\u00e0"));
        this.rows.add((Row)new RowImpl().setNumber(2).addValue("Bbbb").addValue("\u00d6\u00f6\u00cf\u00ef"));
        try (PrintStream out = new PrintStream(this.filePlatform);){
            for (Row row : this.rows) {
                boolean first = true;
                for (String value : row.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(';');
                    }
                    out.print(value);
                }
                out.println();
            }
            out.close();
        }
        FileEncoder.MainArgs margs = new FileEncoder.MainArgs();
        margs.setEnabled(FileEncoder.MainArgs.Feature.VERBOSE, true);
        margs.input = this.filePlatform;
        margs.inputCharset = null;
        margs.output = this.fileUtf8;
        margs.outputCharset = "UTF-8";
        FileEncoder.execute((FileEncoder.MainArgs)margs);
        margs.output = this.fileUtf16;
        margs.outputCharset = "UTF-16";
        FileEncoder.execute((FileEncoder.MainArgs)margs);
    }

    private void testParseFile(File file, String charset) throws Exception {
        LOGGER.debug("testParseFile(" + file + ", " + charset + ")");
        Handler handler = new Handler();
        CsvParser parser = new CsvParser();
        parser.setSeparator(';');
        parser.parse(file, charset, (TableHandler)handler, true);
        Assert.assertEquals(this.rows, handler.rows);
    }

    @Test
    public void testParseFile() throws Exception {
        this.testParseFile(this.filePlatform, null);
        this.testParseFile(this.fileUtf8, "UTF-8");
        this.testParseFile(this.fileUtf16, "UTF-16");
    }

    private class Handler
    implements TableHandler {
        public List<Row> rows = new ArrayList<Row>();

        public void processBegin() {
            LOGGER.debug("processBegin()");
        }

        public Evaluation processHeader(Row header) throws Exception {
            LOGGER.debug("processHeader(" + header + ")");
            this.rows.add((Row)new RowImpl(header));
            return Evaluation.CONTINUE;
        }

        public Evaluation processData(Row data) throws Exception {
            LOGGER.debug("processRow(" + data + ")");
            this.rows.add((Row)new RowImpl(data));
            return Evaluation.CONTINUE;
        }

        public void processEnd() {
            LOGGER.debug("processEnd()");
        }
    }
}

