/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.cli.EnumMask;
import cdc.util.cli.OptionEnum;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class AbstractFilter<M extends BaseMainArgs> {
    protected final M margs;
    private static final String INPUT_CHARSET = "input-charset";
    private static final String INPUT_SEPARATOR = "input-separator";
    private static final String OUTPUT_CHARSET = "output-charset";
    private static final String OUTPUT_SEPARATOR = "output-separator";
    protected static final String COLUMNS = "columns";

    protected AbstractFilter(M margs) {
        this.margs = margs;
    }

    protected Reader getInputReader() throws IOException {
        if (((BaseMainArgs)this.margs).inputCharset == null) {
            return new BufferedReader(new InputStreamReader(new FileInputStream(((BaseMainArgs)this.margs).input)));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(((BaseMainArgs)this.margs).input), ((BaseMainArgs)this.margs).inputCharset));
    }

    protected Writer getOutputWriter() throws IOException {
        if (((BaseMainArgs)this.margs).outputCharset == null) {
            return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(((BaseMainArgs)this.margs).output)));
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(((BaseMainArgs)this.margs).output), ((BaseMainArgs)this.margs).outputCharset));
    }

    protected static void addSpecificBaseOptions(Options options) {
        options.addOption(Option.builder().longOpt("input").desc("Name of the input file.").hasArg().required().build());
        options.addOption(Option.builder().longOpt(INPUT_CHARSET).desc("Optional name of the input charset (default: platform default charset).").hasArg().build());
        options.addOption(Option.builder().longOpt(INPUT_SEPARATOR).desc("Optional input char separator (default: ';').").hasArg().build());
        options.addOption(Option.builder().longOpt("output").desc("Name of the output file.").hasArg().required().build());
        options.addOption(Option.builder().longOpt(OUTPUT_CHARSET).desc("Optional name of the output charset (default: input charset).").hasArg().build());
        options.addOption(Option.builder().longOpt(OUTPUT_SEPARATOR).desc("Optional output char separator (default: input separator).").hasArg().build());
        AbstractMainSupport.addNoArgOptions((Options)options, BaseMainArgs.BaseFeature.class);
    }

    protected static void analyze(CommandLine cl, BaseMainArgs margs) throws ParseException {
        margs.input = AbstractMainSupport.getValueAsNullOrExistingFile((CommandLine)cl, (String)"input", null);
        if (cl.hasOption(INPUT_CHARSET)) {
            margs.inputCharset = cl.getOptionValue(INPUT_CHARSET);
        }
        margs.output = AbstractMainSupport.getValueAsFile((CommandLine)cl, (String)"output", null);
        margs.outputCharset = cl.hasOption(OUTPUT_CHARSET) ? cl.getOptionValue(OUTPUT_CHARSET) : margs.inputCharset;
        margs.inputSeparator = AbstractMainSupport.getValueAsChar((CommandLine)cl, (String)INPUT_SEPARATOR, (char)';');
        margs.outputSeparator = AbstractMainSupport.getValueAsChar((CommandLine)cl, (String)OUTPUT_SEPARATOR, (char)margs.inputSeparator);
        AbstractMainSupport.setMask((CommandLine)cl, BaseMainArgs.BaseFeature.class, (arg_0, arg_1) -> margs.baseFeatures.setEnabled(arg_0, arg_1));
    }

    public static class BaseMainArgs {
        public File input;
        public String inputCharset;
        public char inputSeparator = (char)59;
        public File output;
        public String outputCharset;
        public char outputSeparator = (char)59;
        protected final EnumMask<BaseFeature> baseFeatures = new EnumMask();

        public String getInputCharset() {
            return this.inputCharset == null ? Charset.defaultCharset().name() : this.inputCharset;
        }

        public String getOutputCharset() {
            return this.outputCharset == null ? this.getInputCharset() : this.outputCharset;
        }

        public final void setEnabled(BaseFeature feature, boolean enabled) {
            this.baseFeatures.setEnabled((Enum)feature, enabled);
        }

        public final boolean isEnabled(BaseFeature feature) {
            return this.baseFeatures.isEnabled((Enum)feature);
        }

        public static enum BaseFeature implements OptionEnum
        {
            HAS_HEADER("has-header", "If set, file has header line."),
            VERBOSE("verbose", "Be verbose.");

            private final String name;
            private final String description;

            private BaseFeature(String name, String description) {
                this.name = name;
                this.description = description;
            }

            public final String getName() {
                return this.name;
            }

            public final String getDescription() {
                return this.description;
            }
        }
    }
}

