/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.csv.CsvParser;
import cdc.util.csv.CsvWriter;
import cdc.util.csv.tools.AbstractFilter;
import cdc.util.function.Evaluation;
import cdc.util.tables.Row;
import cdc.util.tables.TableHandler;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SeparatorConverter
extends AbstractFilter<MainArgs> {
    protected static final Logger LOGGER = LogManager.getLogger(SeparatorConverter.class);

    private SeparatorConverter(MainArgs margs) {
        super(margs);
    }

    protected void execute() throws Exception {
        Handler handler = new Handler();
        CsvParser parser = new CsvParser();
        parser.setSeparator(((MainArgs)this.margs).inputSeparator);
        if (((MainArgs)this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.VERBOSE)) {
            LOGGER.info("Load '" + ((MainArgs)this.margs).input + "' (charset: " + ((MainArgs)this.margs).getInputCharset() + ")");
        }
        parser.parse(((MainArgs)this.margs).input, ((MainArgs)this.margs).inputCharset, (TableHandler)handler, ((MainArgs)this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.HAS_HEADER));
    }

    public static void execute(MainArgs margs) throws Exception {
        SeparatorConverter instance = new SeparatorConverter(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        public MainSupport() {
            super(SeparatorConverter.class, LOGGER);
        }

        protected String getVersion() {
            return "0.0.8";
        }

        protected void addSpecificOptions(Options options) {
            AbstractFilter.addSpecificBaseOptions(options);
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            AbstractFilter.analyze(cl, margs);
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            SeparatorConverter.execute(margs);
            return null;
        }
    }

    private class Handler
    implements TableHandler {
        final CsvWriter writer;

        public Handler() throws IOException {
            this.writer = new CsvWriter(((MainArgs)SeparatorConverter.this.margs).output, ((MainArgs)SeparatorConverter.this.margs).outputCharset);
            this.writer.setSeparator(((MainArgs)SeparatorConverter.this.margs).outputSeparator);
        }

        public void processBegin() throws Exception {
        }

        public Evaluation processHeader(Row header) throws Exception {
            this.writer.writeln(header.getValues());
            return Evaluation.CONTINUE;
        }

        public Evaluation processData(Row data) throws Exception {
            this.writer.writeln(data.getValues());
            return Evaluation.CONTINUE;
        }

        public void processEnd() throws IOException {
            this.writer.close();
            if (((MainArgs)SeparatorConverter.this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.VERBOSE)) {
                LOGGER.info("Generated '" + ((MainArgs)SeparatorConverter.this.margs).output + "' (charset: " + ((MainArgs)SeparatorConverter.this.margs).getOutputCharset() + ")");
            }
        }
    }

    public static class MainArgs
    extends AbstractFilter.BaseMainArgs {
    }
}

