/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv;

import java.io.PrintStream;
import java.io.PrintWriter;

public final class CsvUtils {
    private CsvUtils() {
    }

    public static boolean needsEscape(String text, char separator) {
        return text != null && (text.indexOf(34) >= 0 || text.indexOf(separator) >= 0 || text.contains("\n"));
    }

    public static String escape(String text, boolean addExternalQuotes) {
        if (text == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (addExternalQuotes) {
            buffer.append('\"');
        }
        for (int index = 0; index < text.length(); ++index) {
            char c = text.charAt(index);
            if (c == '\"') {
                buffer.append("\"\"");
                continue;
            }
            buffer.append(c);
        }
        if (addExternalQuotes) {
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static String escapeIfNecessary(String text, char separator) {
        if (CsvUtils.needsEscape(text, separator)) {
            return CsvUtils.escape(text, true);
        }
        return text;
    }

    public static void print(CharSequence[] items, char separator, PrintWriter out) {
        boolean first = true;
        for (CharSequence cs : items) {
            if (!first) {
                out.print(separator);
            }
            if (cs != null) {
                out.print(CsvUtils.escapeIfNecessary(cs.toString(), separator));
            }
            first = false;
        }
    }

    public static void print(CharSequence[] items, char separator, PrintStream out) {
        boolean first = true;
        for (CharSequence cs : items) {
            if (!first) {
                out.print(separator);
            }
            if (cs != null) {
                out.print(CsvUtils.escapeIfNecessary(cs.toString(), separator));
            }
            first = false;
        }
    }
}

