/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv;

import cdc.util.csv.CsvUtils;
import cdc.util.strings.StringConversion;
import cdc.util.tables.Row;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;

public class CsvWriter
implements Flushable,
Closeable {
    public static final char DEFAULT_SEPARATOR = ';';
    private String lineSeparator = System.getProperty("line.separator");
    private final Writer writer;
    private char separator = (char)59;
    private Status status = Status.START_LINE;

    public CsvWriter(Writer writer) {
        this.writer = writer;
    }

    public CsvWriter(PrintStream s, String charset) {
        this.writer = charset == null ? new BufferedWriter(new OutputStreamWriter(s)) : new BufferedWriter(new OutputStreamWriter((OutputStream)s, Charset.forName(charset)));
    }

    public CsvWriter(PrintStream s) {
        this(s, null);
    }

    public CsvWriter(String filename, String charset, boolean append) throws IOException {
        this.writer = charset == null ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), charset));
    }

    public CsvWriter(String filename, String charset) throws IOException {
        this(filename, charset, false);
    }

    public CsvWriter(String filename, boolean append) throws IOException {
        this(filename, null, append);
    }

    public CsvWriter(String filename) throws IOException {
        this(filename, null, false);
    }

    public CsvWriter(File file, String charset, boolean append) throws IOException {
        this(file.getPath(), charset, append);
    }

    public CsvWriter(File file, String charset) throws IOException {
        this(file, charset, false);
    }

    public CsvWriter(File file, boolean append) throws IOException {
        this(file, null, append);
    }

    public CsvWriter(File file) throws IOException {
        this(file, null, false);
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char sep) {
        this.separator = sep;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String sep) {
        this.lineSeparator = sep;
    }

    public void writeln() throws IOException {
        this.writer.write(this.lineSeparator);
        this.status = Status.START_LINE;
    }

    public void write(CharSequence value, boolean forceEscape) throws IOException {
        if (value == null) {
            this.write((String)null);
        } else {
            this.write(value.toString(), forceEscape);
        }
    }

    public void write(CharSequence value) throws IOException {
        this.write(value, false);
    }

    public void write(String value, boolean forceEscape) throws IOException {
        String tmp;
        if (this.status == Status.IN_LINE) {
            this.writer.write(this.separator);
        } else {
            this.status = Status.IN_LINE;
        }
        String string = tmp = forceEscape ? CsvUtils.escape(value, true) : CsvUtils.escapeIfNecessary(value, this.separator);
        if (tmp != null) {
            this.writer.write(tmp);
        }
    }

    public void write(String value) throws IOException {
        this.write(value, false);
    }

    public void write(Collection<String> values, boolean forceEscape) throws IOException {
        for (String value : values) {
            this.write(value, forceEscape);
        }
    }

    public void write(Collection<String> values) throws IOException {
        this.write(values, false);
    }

    public void writeln(Collection<String> values, boolean forceEscape) throws IOException {
        this.write(values, forceEscape);
        this.writeln();
    }

    public void writeln(Collection<String> values) throws IOException {
        this.writeln(values, false);
    }

    public void writeln(Row row) throws IOException {
        this.writeln(row.getValues());
    }

    public void write(boolean forceEscape, String ... values) throws IOException {
        for (String value : values) {
            this.write(value, forceEscape);
        }
    }

    public void write(String ... values) throws IOException {
        this.write(false, values);
    }

    public void writeln(boolean forceEscape, String ... values) throws IOException {
        this.write(forceEscape, values);
        this.writeln();
    }

    public void writeln(String ... values) throws IOException {
        this.writeln(false, values);
    }

    public void write(boolean value) throws IOException {
        this.write(StringConversion.asString((boolean)value), false);
    }

    public void write(long value) throws IOException {
        this.write(StringConversion.asString((long)value), false);
    }

    public void write(int value) throws IOException {
        this.write(StringConversion.asString((int)value), false);
    }

    public void write(short value) throws IOException {
        this.write(StringConversion.asString((short)value), false);
    }

    public void write(byte value) throws IOException {
        this.write(StringConversion.asString((byte)value), false);
    }

    public void write(double value) throws IOException {
        this.write(StringConversion.asString((double)value), false);
    }

    public void write(float value) throws IOException {
        this.write(StringConversion.asString((float)value), false);
    }

    public <E extends Enum<E>> void write(E value) throws IOException {
        this.write(StringConversion.asString(value), false);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.status = null;
        this.writer.close();
    }

    private static enum Status {
        START_LINE,
        IN_LINE;

    }
}

