/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.csv.CsvParser;
import cdc.util.csv.CsvWriter;
import cdc.util.csv.tools.AbstractFilter;
import cdc.util.function.Evaluation;
import cdc.util.lang.ExceptionWrapper;
import cdc.util.tables.Row;
import cdc.util.tables.RowLocation;
import cdc.util.tables.TableHandler;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SeparatorConverter
extends AbstractFilter<MainArgs> {
    protected static final Logger LOGGER = LogManager.getLogger(SeparatorConverter.class);

    private SeparatorConverter(MainArgs margs) {
        super(margs);
    }

    protected void execute() throws IOException {
        Handler handler = new Handler();
        CsvParser parser = new CsvParser();
        parser.setSeparator(((MainArgs)this.margs).inputSeparator);
        if (((MainArgs)this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.VERBOSE)) {
            LOGGER.info("Load '{}' (charset: {})", (Object)((MainArgs)this.margs).input, (Object)((MainArgs)this.margs).getInputCharset());
        }
        parser.parse(((MainArgs)this.margs).input, ((MainArgs)this.margs).inputCharset, (TableHandler)handler, ((MainArgs)this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.HAS_HEADER));
    }

    public static void execute(MainArgs margs) throws IOException {
        SeparatorConverter instance = new SeparatorConverter(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        public MainSupport() {
            super(SeparatorConverter.class, LOGGER);
        }

        protected String getVersion() {
            return "0.5.0";
        }

        protected void addSpecificOptions(Options options) {
            AbstractFilter.addSpecificBaseOptions(options);
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            AbstractFilter.analyze(cl, margs);
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            SeparatorConverter.execute(margs);
            return null;
        }
    }

    private final class Handler
    implements TableHandler {
        final CsvWriter writer;

        public Handler() throws IOException {
            this.writer = new CsvWriter(((MainArgs)SeparatorConverter.this.margs).output, ((MainArgs)SeparatorConverter.this.margs).outputCharset);
            this.writer.setSeparator(((MainArgs)SeparatorConverter.this.margs).outputSeparator);
        }

        public void processBegin() {
        }

        public Evaluation processHeader(Row header, RowLocation location) {
            try {
                this.writer.writeln(header.getValues());
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((Exception)e);
            }
            return Evaluation.CONTINUE;
        }

        public Evaluation processData(Row data, RowLocation location) {
            try {
                this.writer.writeln(data.getValues());
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((Exception)e);
            }
            return Evaluation.CONTINUE;
        }

        public void processEnd() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((Exception)e);
            }
            if (((MainArgs)SeparatorConverter.this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.VERBOSE)) {
                LOGGER.info("Generated '{}' (charset: {})", (Object)((MainArgs)SeparatorConverter.this.margs).output, (Object)((MainArgs)SeparatorConverter.this.margs).getOutputCharset());
            }
        }
    }

    public static class MainArgs
    extends AbstractFilter.BaseMainArgs {
    }
}

