/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.csv;

import cdc.util.csv.CsvParser;
import cdc.util.function.Evaluation;
import cdc.util.tables.Row;
import cdc.util.tables.RowLocation;
import cdc.util.tables.TableHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CsvParserTest {
    protected static final Logger LOGGER = LogManager.getLogger(CsvParserTest.class);
    private static final char SEPARATOR = ';';
    private final List<Row> rows = new ArrayList<Row>();
    private final File filePlatform = new File("target", this.getClass().getSimpleName() + "-platform.txt");

    CsvParserTest() throws IOException {
        this.rows.add(Row.builder((String[])new String[]{"V1", "V2"}).build());
        this.rows.add(Row.builder((String[])new String[]{"Aaaa", "\u00e0\u00e0\u00e0"}).build());
        this.rows.add(Row.builder((String[])new String[]{"Bbbb", "\u00d6\u00f6\u00cf\u00ef"}).build());
        try (PrintStream out = new PrintStream(this.filePlatform);){
            for (Row row : this.rows) {
                boolean first = true;
                for (String value : row.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(';');
                    }
                    out.print(value);
                }
                out.println();
            }
            out.close();
        }
    }

    private void testParseFile(File file, String charset) throws Exception {
        LOGGER.debug("testParseFile({}, {})", (Object)file, (Object)charset);
        Handler handler = new Handler();
        CsvParser parser = new CsvParser();
        parser.setSeparator(';');
        parser.parse(file, charset, (TableHandler)handler, true);
        Assertions.assertEquals(this.rows, handler.rows);
        Assertions.assertEquals((int)1, (int)handler.headers);
        Assertions.assertEquals((int)2, (int)handler.datas);
    }

    @Test
    void testParseFile() throws Exception {
        this.testParseFile(this.filePlatform, null);
    }

    private static final class Handler
    implements TableHandler {
        public List<Row> rows = new ArrayList<Row>();
        public int headers = 0;
        public int datas = 0;

        public void processBegin(String name) {
            LOGGER.debug("processBegin({})", (Object)name);
        }

        public Evaluation processHeader(Row header, RowLocation location) {
            LOGGER.debug("processHeader({}, {})", (Object)header, (Object)location);
            this.rows.add(header);
            ++this.headers;
            return Evaluation.CONTINUE;
        }

        public Evaluation processData(Row data, RowLocation location) {
            LOGGER.debug("processData({}, {})", (Object)data, (Object)location);
            this.rows.add(data);
            ++this.datas;
            return Evaluation.CONTINUE;
        }

        public void processEnd() {
            LOGGER.debug("processEnd()");
        }
    }
}

