/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv;

import cdc.util.csv.CsvParser;
import cdc.util.lang.ImplementationException;
import cdc.util.tables.MemoryTableHandler;
import cdc.util.tables.Row;
import cdc.util.tables.TableHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CsvLoader {
    private static final Logger LOGGER = LogManager.getLogger(CsvLoader.class);

    private CsvLoader() {
    }

    public static List<Row> load(File file, String charset, char separator) throws IOException {
        LOGGER.debug("load({}, {}, {})", (Object)file, (Object)charset, (Object)Character.valueOf(separator));
        CsvParser parser = new CsvParser(separator);
        MemoryTableHandler handler = new MemoryTableHandler();
        try {
            parser.parse(file, charset, (TableHandler)handler, 0);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImplementationException((Throwable)e);
        }
        return handler.getRows();
    }

    public static List<Row> load(InputStream in, String charset, char separator) throws IOException {
        LOGGER.debug("load({}, {})", (Object)charset, (Object)Character.valueOf(separator));
        CsvParser parser = new CsvParser(separator);
        MemoryTableHandler handler = new MemoryTableHandler();
        try {
            parser.parse(in, charset, (TableHandler)handler, 0);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImplementationException((Throwable)e);
        }
        return handler.getRows();
    }
}

