/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv;

import cdc.util.csv.CsvUtils;
import cdc.util.strings.StringConversion;
import cdc.util.tables.Row;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;

public class CsvWriter
implements Flushable,
Closeable {
    public static final char DEFAULT_SEPARATOR = ';';
    private String lineSeparator = System.getProperty("line.separator");
    private final Writer writer;
    private char separator = (char)59;
    private Status status = Status.START_LINE;

    public CsvWriter(Writer writer) {
        this.writer = writer;
    }

    public CsvWriter(PrintStream s, String charset) {
        this.writer = charset == null ? new BufferedWriter(new OutputStreamWriter(s)) : new BufferedWriter(new OutputStreamWriter((OutputStream)s, Charset.forName(charset)));
    }

    public CsvWriter(PrintStream s) {
        this(s, null);
    }

    public CsvWriter(String filename, String charset, boolean append) throws IOException {
        this.writer = charset == null ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), charset));
    }

    public CsvWriter(String filename, String charset) throws IOException {
        this(filename, charset, false);
    }

    public CsvWriter(String filename, boolean append) throws IOException {
        this(filename, null, append);
    }

    public CsvWriter(String filename) throws IOException {
        this(filename, null, false);
    }

    public CsvWriter(File file, String charset, boolean append) throws IOException {
        this(file.getPath(), charset, append);
    }

    public CsvWriter(File file, String charset) throws IOException {
        this(file, charset, false);
    }

    public CsvWriter(File file, boolean append) throws IOException {
        this(file, null, append);
    }

    public CsvWriter(File file) throws IOException {
        this(file, null, false);
    }

    public char getSeparator() {
        return this.separator;
    }

    public CsvWriter setSeparator(char sep) {
        this.separator = sep;
        return this;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public CsvWriter setLineSeparator(String sep) {
        this.lineSeparator = sep;
        return this;
    }

    public CsvWriter writeln() throws IOException {
        this.writer.write(this.lineSeparator);
        this.status = Status.START_LINE;
        return this;
    }

    public CsvWriter write(CharSequence value, boolean forceEscape) throws IOException {
        if (value == null) {
            return this.write((String)null);
        }
        return this.write(value.toString(), forceEscape);
    }

    public CsvWriter write(CharSequence value) throws IOException {
        return this.write(value, false);
    }

    public CsvWriter write(String value, boolean forceEscape) throws IOException {
        String tmp;
        if (this.status == Status.IN_LINE) {
            this.writer.write(this.separator);
        } else {
            this.status = Status.IN_LINE;
        }
        String string = tmp = forceEscape ? CsvUtils.escape(value, true) : CsvUtils.escapeIfNecessary(value, this.separator);
        if (tmp != null) {
            this.writer.write(tmp);
        }
        return this;
    }

    public CsvWriter write(String value) throws IOException {
        return this.write(value, false);
    }

    public CsvWriter write(Collection<String> values, boolean forceEscape) throws IOException {
        for (String value : values) {
            this.write(value, forceEscape);
        }
        return this;
    }

    public CsvWriter write(Collection<String> values) throws IOException {
        return this.write(values, false);
    }

    public CsvWriter writeln(Collection<String> values, boolean forceEscape) throws IOException {
        this.write(values, forceEscape);
        return this.writeln();
    }

    public CsvWriter writeln(Collection<String> values) throws IOException {
        return this.writeln(values, false);
    }

    public CsvWriter writeln(Row row) throws IOException {
        return this.writeln(row.getValues());
    }

    public CsvWriter write(boolean forceEscape, String ... values) throws IOException {
        for (String value : values) {
            this.write(value, forceEscape);
        }
        return this;
    }

    public CsvWriter write(String ... values) throws IOException {
        return this.write(false, values);
    }

    public CsvWriter writeln(boolean forceEscape, String ... values) throws IOException {
        this.write(forceEscape, values);
        return this.writeln();
    }

    public CsvWriter writeln(String ... values) throws IOException {
        return this.writeln(false, values);
    }

    public CsvWriter write(boolean value) throws IOException {
        return this.write(StringConversion.asString((boolean)value), false);
    }

    public CsvWriter write(long value) throws IOException {
        return this.write(StringConversion.asString((long)value), false);
    }

    public CsvWriter write(int value) throws IOException {
        return this.write(StringConversion.asString((int)value), false);
    }

    public CsvWriter write(short value) throws IOException {
        return this.write(StringConversion.asString((short)value), false);
    }

    public CsvWriter write(byte value) throws IOException {
        return this.write(StringConversion.asString((byte)value), false);
    }

    public CsvWriter write(double value) throws IOException {
        return this.write(StringConversion.asString((double)value), false);
    }

    public CsvWriter write(float value) throws IOException {
        return this.write(StringConversion.asString((float)value), false);
    }

    public <E extends Enum<E>> CsvWriter write(E value) throws IOException {
        return this.write(StringConversion.asString(value), false);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.status = null;
        this.writer.close();
    }

    private static enum Status {
        START_LINE,
        IN_LINE;

    }
}

