/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.cli.FeatureMask;
import cdc.util.cli.OptionEnum;
import cdc.util.csv.CsvParser;
import cdc.util.csv.CsvWriter;
import cdc.util.csv.tools.AbstractFilter;
import cdc.util.function.Evaluation;
import cdc.util.lang.ExceptionWrapper;
import cdc.util.strings.StringAnonymizer;
import cdc.util.strings.StringConversion;
import cdc.util.tables.Row;
import cdc.util.tables.RowLocation;
import cdc.util.tables.TableHandler;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Anonymizer
extends AbstractFilter<MainArgs> {
    protected static final Logger LOGGER = LogManager.getLogger(Anonymizer.class);

    private Anonymizer(MainArgs margs) {
        super(margs);
    }

    protected void execute() throws IOException {
        Handler handler = new Handler();
        CsvParser parser = new CsvParser();
        parser.setSeparator(((MainArgs)this.margs).inputSeparator);
        if (((MainArgs)this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.VERBOSE)) {
            LOGGER.info("Load '{}' (charset: {})", (Object)((MainArgs)this.margs).input, (Object)((MainArgs)this.margs).getInputCharset());
        }
        parser.parse(((MainArgs)this.margs).input, ((MainArgs)this.margs).inputCharset, (TableHandler)handler, ((MainArgs)this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.HAS_HEADER));
    }

    public static void execute(MainArgs margs) throws IOException {
        Anonymizer instance = new Anonymizer(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        private static final String REPLACEMENT = "replacement";
        private static final String PRESERVE_CHARS = "preserve-chars";
        private static final String MAX_LENGTH = "max-length";

        public MainSupport() {
            super(Anonymizer.class, LOGGER);
        }

        protected String getVersion() {
            return "0.8.0";
        }

        protected void addSpecificOptions(Options options) {
            AbstractFilter.addSpecificBaseOptions(options);
            options.addOption(Option.builder().longOpt("columns").desc("Columns (1-based) to anonymize.").hasArgs().required().build());
            options.addOption(Option.builder().longOpt(REPLACEMENT).desc("Optional replacement character (default: 'X').").hasArgs().build());
            options.addOption(Option.builder().longOpt(PRESERVE_CHARS).desc("Optional characters to preserve (default: none).").hasArgs().build());
            options.addOption(Option.builder().longOpt(MAX_LENGTH).desc("Optional max length of values (default: -1).").hasArg().build());
            AbstractMainSupport.addNoArgOptions((Options)options, MainArgs.Feature.class);
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            AbstractFilter.analyze(cl, margs);
            for (String s : cl.getOptionValues("columns")) {
                try {
                    int number = StringConversion.asInt((String)s);
                    margs.columns.add(number);
                }
                catch (Exception e) {
                    throw new ParseException(e.getMessage());
                }
            }
            margs.replacement = MainSupport.getValueAsChar((CommandLine)cl, (String)REPLACEMENT, (char)'X');
            margs.preservedCharacters = cl.getOptionValue(PRESERVE_CHARS);
            margs.maxLength = MainSupport.getValueAsInt((CommandLine)cl, (String)MAX_LENGTH, (int)-1);
            AbstractMainSupport.setMask((CommandLine)cl, MainArgs.Feature.class, (arg_0, arg_1) -> margs.features.setEnabled(arg_0, arg_1));
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            Anonymizer.execute(margs);
            return null;
        }
    }

    private final class Handler
    implements TableHandler {
        final CsvWriter writer;
        final StringAnonymizer anonymizer = new StringAnonymizer();

        public Handler() throws IOException {
            this.writer = new CsvWriter(((MainArgs)Anonymizer.this.margs).output, ((MainArgs)Anonymizer.this.margs).outputCharset);
            this.writer.setSeparator(((MainArgs)Anonymizer.this.margs).outputSeparator);
            this.anonymizer.setReplacement(((MainArgs)Anonymizer.this.margs).replacement);
            this.anonymizer.setPreservedCharacters(((MainArgs)Anonymizer.this.margs).preservedCharacters);
            this.anonymizer.setMaxLength(((MainArgs)Anonymizer.this.margs).maxLength);
            this.anonymizer.setEnabled(StringAnonymizer.Feature.PRESERVE_WHITESPACES, ((MainArgs)Anonymizer.this.margs).isEnabled(MainArgs.Feature.PRESERVE_WHITESPACES));
            this.anonymizer.setEnabled(StringAnonymizer.Feature.JAM, ((MainArgs)Anonymizer.this.margs).isEnabled(MainArgs.Feature.JAM));
        }

        public void processBegin(String name) {
        }

        public Evaluation processHeader(Row header, RowLocation location) {
            try {
                this.writer.writeln(header.getValues());
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((Exception)e);
            }
            return Evaluation.CONTINUE;
        }

        public Evaluation processData(Row data, RowLocation location) {
            try {
                for (int column = 0; column < data.getColumnsCount(); ++column) {
                    String value = data.getValue(column);
                    if (((MainArgs)Anonymizer.this.margs).columns.contains(column + 1)) {
                        this.writer.write(this.anonymizer.anonymize(value));
                        continue;
                    }
                    this.writer.write(value);
                }
                this.writer.writeln();
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((Exception)e);
            }
            return Evaluation.CONTINUE;
        }

        public void processEnd() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap((Exception)e);
            }
            if (((MainArgs)Anonymizer.this.margs).isEnabled(AbstractFilter.BaseMainArgs.BaseFeature.VERBOSE)) {
                LOGGER.info("Generated '{}' (charset: {})", (Object)((MainArgs)Anonymizer.this.margs).output, (Object)((MainArgs)Anonymizer.this.margs).getOutputCharset());
            }
        }
    }

    public static class MainArgs
    extends AbstractFilter.BaseMainArgs {
        public final Set<Integer> columns = new HashSet<Integer>();
        public char replacement = (char)88;
        public String preservedCharacters = null;
        public int maxLength = -1;
        protected final FeatureMask<Feature> features = new FeatureMask();

        public final void setEnabled(Feature feature, boolean enabled) {
            this.features.setEnabled((Enum)feature, enabled);
        }

        public final boolean isEnabled(Feature feature) {
            return this.features.isEnabled((Enum)feature);
        }

        public static enum Feature implements OptionEnum
        {
            PRESERVE_WHITESPACES("preserve-whitespaces", "If set, white spaces are perserved."),
            JAM("jam", "If set, characters are jammed instead of being replaced by the same character.");

            private final String name;
            private final String description;

            private Feature(String name, String description) {
                this.name = name;
                this.description = description;
            }

            public final String getName() {
                return this.name;
            }

            public final String getDescription() {
                return this.description;
            }
        }
    }
}

