/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.csv;

import cdc.util.csv.CsvUtils;
import cdc.util.function.Evaluation;
import cdc.util.lang.Checks;
import cdc.util.lang.ImplementationException;
import cdc.util.lang.InvalidStateException;
import cdc.util.tables.Row;
import cdc.util.tables.RowLocation;
import cdc.util.tables.TableHandler;
import cdc.util.tables.TableSection;
import cdc.util.txt.LineParser;
import cdc.util.txt.LinesHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CsvParser {
    private static final Logger LOGGER = LogManager.getLogger(CsvParser.class);
    private char separator;
    private boolean verbose = false;
    private boolean countRows = false;
    private boolean voidHandler = false;

    public CsvParser() {
        this.separator = (char)59;
    }

    public CsvParser(char separator) {
        this.separator = separator;
    }

    public CsvParser setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public CsvParser countRows(boolean countRows) {
        this.countRows = countRows;
        return this;
    }

    CsvParser setVoidHandler() {
        this.voidHandler = true;
        return this;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void traceBegin(Object object) {
        if (this.verbose) {
            LOGGER.info("Load: '{}' ... ", object);
        }
    }

    private void traceEnd() {
        if (this.verbose) {
            LOGGER.info("Done");
        }
    }

    private LinesHandler createLinesHandler(TableHandler handler, int headers, int numberOfRows) {
        if (this.voidHandler) {
            return new VoidHandler(handler, headers, numberOfRows);
        }
        return new Handler(handler, headers, numberOfRows);
    }

    public void parse(Reader reader, TableHandler handler, int headers) throws IOException {
        int numberOfRows;
        if (this.countRows) {
            if (reader.markSupported()) {
                reader.mark(Integer.MAX_VALUE);
                numberOfRows = CsvUtils.getNumberOfCsvRows(reader, this.separator);
                reader.reset();
            } else {
                LOGGER.warn("Cannot count rows, reader does not support marks.");
                numberOfRows = -1;
            }
        } else {
            numberOfRows = -1;
        }
        LineParser.parse((Reader)reader, (LinesHandler)this.createLinesHandler(handler, headers, numberOfRows));
    }

    public void parse(InputStream in, String charset, TableHandler handler, int headers) throws IOException {
        int numberOfRows;
        if (this.countRows) {
            if (in.markSupported()) {
                in.mark(Integer.MAX_VALUE);
                numberOfRows = CsvUtils.getNumberOfCsvRows(in, charset, this.separator);
                in.reset();
            } else {
                LOGGER.warn("Cannot count rows, stream does not support marks.");
                numberOfRows = -1;
            }
        } else {
            numberOfRows = -1;
        }
        LineParser.parse((InputStream)in, (String)charset, (LinesHandler)this.createLinesHandler(handler, headers, numberOfRows));
    }

    public void parse(InputStream in, TableHandler handler, int headers) throws IOException {
        this.parse(in, Charset.defaultCharset().name(), handler, headers);
    }

    public void parse(File file, String charset, TableHandler handler, int headers) throws IOException {
        this.traceBegin(file);
        int numberORows = this.countRows ? CsvUtils.getNumberOfCsvRows(file, charset, this.separator) : -1;
        LineParser.parse((File)file, (String)charset, (LinesHandler)this.createLinesHandler(handler, headers, numberORows));
        this.traceEnd();
    }

    public void parse(File file, TableHandler handler, int headers) throws IOException {
        this.parse(file, null, handler, headers);
    }

    private class VoidHandler
    implements LinesHandler {
        private final TableHandler tableHandler;
        private final int headers;
        private final int numberOfRows;
        private Status currentStatus = Status.LINE_OUT;
        private final RowLocation.Builder location = RowLocation.builder();
        private Evaluation evaluation = Evaluation.CONTINUE;

        VoidHandler(TableHandler handler, int headers, int numberOfRows) {
            Checks.isNotNull((Object)handler, (String)"handler");
            Checks.isTrue((headers >= 0 ? 1 : 0) != 0, (String)"invalid headers");
            this.tableHandler = handler;
            this.headers = headers;
            this.numberOfRows = numberOfRows;
        }

        private void implementationError() {
            throw new ImplementationException("unhandled status: " + (Object)((Object)this.currentStatus));
        }

        public void processBegin() {
            this.tableHandler.processBegin(null, this.numberOfRows);
        }

        public void processEnd() {
            switch (this.currentStatus) {
                case FIELD_IN_QUOTE: 
                case FIELD_IN_SPEC: 
                case FIELD_IN_STD: {
                    throw new InvalidStateException("Invalid status (" + (Object)((Object)this.currentStatus) + ") at the end of parsing.");
                }
                case FIELD_OUT: 
                case LINE_OUT: {
                    break;
                }
                default: {
                    this.implementationError();
                }
            }
            this.tableHandler.processEnd();
        }

        public Evaluation processLine(String line, int number) {
            block20: for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '\"') {
                    switch (this.currentStatus) {
                        case FIELD_OUT: 
                        case LINE_OUT: {
                            this.setStatus(Status.FIELD_IN_SPEC);
                            break;
                        }
                        case FIELD_IN_STD: {
                            break;
                        }
                        case FIELD_IN_SPEC: {
                            this.setStatus(Status.FIELD_IN_QUOTE);
                            break;
                        }
                        case FIELD_IN_QUOTE: {
                            this.setStatus(Status.FIELD_IN_SPEC);
                            break;
                        }
                        default: {
                            this.implementationError();
                            break;
                        }
                    }
                    continue;
                }
                if (c == CsvParser.this.separator) {
                    switch (this.currentStatus) {
                        case FIELD_IN_QUOTE: 
                        case FIELD_IN_STD: 
                        case FIELD_OUT: 
                        case LINE_OUT: {
                            this.setStatus(Status.FIELD_OUT);
                            break;
                        }
                        case FIELD_IN_SPEC: {
                            break;
                        }
                        default: {
                            this.implementationError();
                            break;
                        }
                    }
                    continue;
                }
                switch (this.currentStatus) {
                    case FIELD_OUT: 
                    case LINE_OUT: {
                        this.setStatus(Status.FIELD_IN_STD);
                        continue block20;
                    }
                    case FIELD_IN_SPEC: 
                    case FIELD_IN_STD: {
                        continue block20;
                    }
                    case FIELD_IN_QUOTE: {
                        this.setStatus(Status.FIELD_IN_SPEC);
                        continue block20;
                    }
                    default: {
                        this.implementationError();
                    }
                }
            }
            switch (this.currentStatus) {
                case FIELD_IN_QUOTE: 
                case FIELD_IN_STD: 
                case FIELD_OUT: {
                    this.setStatus(Status.FIELD_OUT);
                    this.flushLineIfAny();
                    break;
                }
                case FIELD_IN_SPEC: {
                    break;
                }
                case LINE_OUT: {
                    this.flushLineIfAny();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this.evaluation;
        }

        private void setStatus(Status status) {
            this.currentStatus = status;
        }

        private void flushLineIfAny() {
            this.location.incrementNumbers(this.headers);
            this.evaluation = this.location.getSection() == TableSection.HEADER ? this.tableHandler.processHeader(null, null) : this.tableHandler.processData(null, null);
            this.setStatus(Status.LINE_OUT);
        }
    }

    private class Handler
    implements LinesHandler {
        private final TableHandler tableHandler;
        private final int headers;
        private final int numberOfRows;
        private Status currentStatus = Status.LINE_OUT;
        private final StringBuilder currentValue = new StringBuilder();
        private final Row.Builder row = Row.builder();
        private final RowLocation.Builder location = RowLocation.builder();
        private Evaluation evaluation = Evaluation.CONTINUE;

        Handler(TableHandler handler, int headers, int numberOfRows) {
            Checks.isNotNull((Object)handler, (String)"handler");
            Checks.isTrue((headers >= 0 ? 1 : 0) != 0, (String)"invalid headers");
            this.tableHandler = handler;
            this.headers = headers;
            this.numberOfRows = numberOfRows;
        }

        private void implementationError() {
            throw new ImplementationException("unhandled status: " + (Object)((Object)this.currentStatus));
        }

        public void processBegin() {
            this.row.clear();
            this.tableHandler.processBegin(null, this.numberOfRows);
        }

        public void processEnd() {
            switch (this.currentStatus) {
                case FIELD_IN_QUOTE: 
                case FIELD_IN_SPEC: 
                case FIELD_IN_STD: {
                    throw new InvalidStateException("Invalid status (" + (Object)((Object)this.currentStatus) + ") at the end of parsing.");
                }
                case FIELD_OUT: 
                case LINE_OUT: {
                    break;
                }
                default: {
                    this.implementationError();
                }
            }
            this.tableHandler.processEnd();
        }

        public Evaluation processLine(String line, int number) {
            block20: for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '\"') {
                    switch (this.currentStatus) {
                        case FIELD_OUT: 
                        case LINE_OUT: {
                            this.setStatus(Status.FIELD_IN_SPEC);
                            break;
                        }
                        case FIELD_IN_STD: {
                            this.appendChar(c);
                            break;
                        }
                        case FIELD_IN_SPEC: {
                            this.setStatus(Status.FIELD_IN_QUOTE);
                            break;
                        }
                        case FIELD_IN_QUOTE: {
                            this.appendChar('\"');
                            this.setStatus(Status.FIELD_IN_SPEC);
                            break;
                        }
                        default: {
                            this.implementationError();
                            break;
                        }
                    }
                    continue;
                }
                if (c == CsvParser.this.separator) {
                    switch (this.currentStatus) {
                        case FIELD_IN_QUOTE: 
                        case FIELD_IN_STD: 
                        case FIELD_OUT: 
                        case LINE_OUT: {
                            this.addValue();
                            break;
                        }
                        case FIELD_IN_SPEC: {
                            this.appendChar(c);
                            break;
                        }
                        default: {
                            this.implementationError();
                            break;
                        }
                    }
                    continue;
                }
                switch (this.currentStatus) {
                    case FIELD_OUT: 
                    case LINE_OUT: {
                        this.appendChar(c);
                        this.setStatus(Status.FIELD_IN_STD);
                        continue block20;
                    }
                    case FIELD_IN_SPEC: 
                    case FIELD_IN_STD: {
                        this.appendChar(c);
                        continue block20;
                    }
                    case FIELD_IN_QUOTE: {
                        this.appendChar(c);
                        this.setStatus(Status.FIELD_IN_SPEC);
                        continue block20;
                    }
                    default: {
                        this.implementationError();
                    }
                }
            }
            switch (this.currentStatus) {
                case FIELD_IN_QUOTE: 
                case FIELD_IN_STD: 
                case FIELD_OUT: {
                    this.addValue();
                    this.flushLineIfAny();
                    break;
                }
                case FIELD_IN_SPEC: {
                    this.appendNewLine();
                    break;
                }
                case LINE_OUT: {
                    this.flushLineIfAny();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this.evaluation;
        }

        private void setStatus(Status status) {
            this.currentStatus = status;
        }

        private void appendChar(char c) {
            this.currentValue.append(c);
        }

        private void appendNewLine() {
            this.currentValue.append('\n');
        }

        private void addValue() {
            this.row.addValue((Object)this.currentValue.toString());
            this.currentValue.setLength(0);
            this.setStatus(Status.FIELD_OUT);
        }

        private void flushLineIfAny() {
            this.location.incrementNumbers(this.headers);
            this.evaluation = this.location.getSection() == TableSection.HEADER ? this.tableHandler.processHeader(this.row.build(), this.location.build()) : this.tableHandler.processData(this.row.build(), this.location.build());
            this.row.clear();
            this.currentValue.setLength(0);
            this.setStatus(Status.LINE_OUT);
        }
    }

    private static enum Status {
        LINE_OUT,
        FIELD_IN_STD,
        FIELD_IN_SPEC,
        FIELD_IN_QUOTE,
        FIELD_OUT;

    }
}

