/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.AbstractChild;
import cdc.util.data.Child;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import java.util.ArrayList;
import java.util.List;

public final class Document
implements Parent {
    private final List<AbstractChild> children = new ArrayList<AbstractChild>();
    private Element root = null;

    @Override
    public NodeType getType() {
        return NodeType.DOCUMENT;
    }

    @Override
    public Document clone(boolean recurse) {
        Document result = new Document();
        if (recurse) {
            for (AbstractChild child : this.getChildren()) {
                result.addChild(child.clone(true));
            }
        }
        return result;
    }

    @Override
    public boolean deepEquals(Node node) {
        if (this == node) {
            return true;
        }
        if (!(node instanceof Document)) {
            return false;
        }
        Document other = (Document)node;
        if (this.getChildrenCount() == other.getChildrenCount()) {
            for (int index = 0; index < this.getChildrenCount(); ++index) {
                if (this.getChildAt(index).deepEquals(other.getChildAt(index))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    @Override
    public Element getRootElement() {
        return this.root;
    }

    public static Element getRootElement(Document document) {
        return document == null ? null : document.getRootElement();
    }

    @Override
    public boolean canAddChild(Child child) {
        if (child != null) {
            if (child.getType() == NodeType.ELEMENT) {
                return this.root == null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void doAddChild(Child child) {
        this.children.add((AbstractChild)child);
        if (child.getType() == NodeType.ELEMENT) {
            this.root = (Element)child;
        }
    }

    @Override
    public void doRemoveChild(Child child) {
        this.children.remove(child);
        if (this.root == child) {
            this.root = null;
        }
    }

    @Override
    public List<AbstractChild> getChildren() {
        return this.children;
    }

    public int hashCode() {
        return this.children.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Document)) {
            return false;
        }
        Document other = (Document)object;
        return this.children.equals(other.children);
    }
}

