/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import java.io.PrintStream;

public class DataStats {
    private final int[] counts = new int[NodeType.values().length];
    private int atts = 0;

    public DataStats(Node node) {
        this.count(node);
    }

    public int getNodesCount(NodeType type) {
        return this.counts[type.ordinal()];
    }

    public int getAttributesCount() {
        return this.atts;
    }

    public void print(PrintStream out) {
        for (NodeType type : NodeType.values()) {
            out.println(type.name() + ": " + this.getNodesCount(type));
        }
        out.println("ATTRIBUTES: " + this.getAttributesCount());
    }

    public static void print(Node node, PrintStream out) {
        DataStats stats = new DataStats(node);
        stats.print(out);
    }

    private void count(Node node) {
        int n = node.getType().ordinal();
        this.counts[n] = this.counts[n] + 1;
        if (node instanceof Element) {
            this.atts += ((Element)node).getAttributesCount();
        }
        if (node instanceof Parent) {
            for (Node node2 : ((Parent)node).getChildren()) {
                this.count(node2);
            }
        }
    }
}

