/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Element;
import cdc.util.data.ElementContentType;
import cdc.util.data.Leaf;
import cdc.util.data.Node;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import cdc.util.lang.FailureReaction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ElementTest {
    private static final String NAME = "name";
    private static final String NAME1 = "name1";
    private static final String NAME2 = "name2";
    private static final String NAME3 = "name3";
    private static final String NAME4 = "name4";
    private static final String VALUE = "value";

    @Test
    public void testConstructors() {
        Element e = new Element(NAME);
        Assertions.assertEquals(null, (Object)e.getParent());
        Assertions.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addComment("comment", true);
        Assertions.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
    }

    @Test
    public void testClone() {
        Element e1 = new Element(NAME);
        e1.addAttribute(NAME1, VALUE);
        e1.addAttribute(NAME2, VALUE);
        Element e2 = e1.clone(true);
        Assertions.assertTrue((boolean)e1.deepEquals((Node)e2));
    }

    @Test
    public void testDeepEquals() {
        Element e1 = new Element(NAME);
        e1.addAttribute(NAME1, VALUE);
        e1.addAttribute(NAME2, VALUE);
        Element e2 = new Element(NAME);
        e2.addAttribute(NAME2, VALUE);
        e2.addAttribute(NAME1, VALUE);
        Assertions.assertTrue((boolean)e1.deepEquals((Node)e2));
    }

    @Test
    public void testContentType() {
        Element e = new Element(NAME);
        Assertions.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addComment("Hello");
        Assertions.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
        e.removeChildren();
        Assertions.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addText("Hello");
        Assertions.assertEquals((Object)ElementContentType.TEXT, (Object)e.getContentType());
        e.addText("World");
        Assertions.assertEquals((Object)ElementContentType.TEXT, (Object)e.getContentType());
        e.addComment("Hello");
        Assertions.assertEquals((Object)ElementContentType.MIXED, (Object)e.getContentType());
        e.removeChildren();
        Assertions.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addElement("child");
        Assertions.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
        e.addComment("Hello");
        Assertions.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
        e.addText("World");
        Assertions.assertEquals((Object)ElementContentType.MIXED, (Object)e.getContentType());
    }

    @Test
    public void testAttributes() {
        Element e = new Element(NAME);
        Assertions.assertEquals((int)0, (int)e.getAttributesCount());
        Assertions.assertFalse((boolean)e.hasAttribute(NAME1));
        Assertions.assertEquals((int)-1, (int)e.getAttributeIndex(NAME1));
        Assertions.assertTrue((boolean)e.getAttributes().isEmpty());
        Assertions.assertEquals(null, (Object)e.getAttributeValue(NAME1));
        e.addAttribute(NAME1, null);
        Assertions.assertTrue((boolean)e.hasAttribute(NAME1));
        Assertions.assertEquals(null, (Object)e.getAttributeValue(NAME1));
        Assertions.assertEquals((int)0, (int)e.getAttributeIndex(NAME1));
        Assertions.assertEquals((int)-1, (int)e.getAttributeIndex(NAME2));
        Assertions.assertFalse((boolean)e.hasAttribute(NAME2));
        Assertions.assertEquals((int)1, (int)e.getAttributes().size());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)e.getAttributeAsOptionalBoolean(NAME1, Boolean.TRUE));
        Assertions.assertEquals((Object)0L, (Object)e.getAttributeAsOptionalLong(NAME1, Long.valueOf(0L)));
        Assertions.assertEquals((Object)0, (Object)e.getAttributeAsOptionalInt(NAME1, Integer.valueOf(0)));
        Assertions.assertEquals((Object)0, (Object)e.getAttributeAsOptionalShort(NAME1, Short.valueOf((short)0)));
        Assertions.assertEquals((Object)0, (Object)e.getAttributeAsOptionalByte(NAME1, Byte.valueOf((byte)0)));
        Assertions.assertEquals((Object)0.0, (Object)e.getAttributeAsOptionalDouble(NAME1, Double.valueOf(0.0)));
        Assertions.assertEquals((Object)Float.valueOf(0.0f), (Object)e.getAttributeAsOptionalFloat(NAME1, Float.valueOf(0.0f)));
        Assertions.assertEquals((Object)FailureReaction.DEFAULT, (Object)e.getAttributeAsOptionalEnum(NAME1, FailureReaction.class, (Enum)FailureReaction.DEFAULT));
    }

    @Test
    public void testChildren() {
        Element e = new Element(NAME);
        Assertions.assertEquals(null, (Object)e.getDocument());
        Assertions.assertEquals((Object)e, (Object)e.getRootElement());
        Assertions.assertEquals((Object)e, (Object)e.getRootChild());
        Element c0 = e.addElement(NAME1);
        Element c1 = e.addElement(NAME1);
        Text c2 = e.addText("Hello");
        Comment c3 = e.addComment("Hello");
        Assertions.assertEquals((Object)c0, (Object)e.getChildAt(0));
        Assertions.assertEquals((Object)c1, (Object)e.getChildAt(1));
        Assertions.assertEquals((Object)c0, (Object)e.getElementNamed(NAME1));
        Assertions.assertEquals(null, (Object)c2.getDocument());
        Assertions.assertEquals((Object)e, (Object)c3.getRootElement());
        Assertions.assertEquals((Object)e, (Object)c3.getRootChild());
        Assertions.assertEquals((Object)e, (Object)c2.getParent());
        Assertions.assertEquals((Object)e, (Object)c2.getParent(Element.class));
        Assertions.assertEquals((int)4, (int)e.getChildrenCount());
        Assertions.assertEquals((int)4, (int)e.getChildrenCount(Node.class));
        Assertions.assertEquals((int)2, (int)e.getChildrenCount(Element.class));
        Assertions.assertEquals((int)1, (int)e.getChildrenCount(Comment.class));
        Assertions.assertEquals((int)1, (int)e.getChildrenCount(Text.class));
        Assertions.assertEquals((int)2, (int)e.getChildrenCount(Parent.class));
        Assertions.assertEquals((int)4, (int)e.getChildrenCount(Child.class));
        Assertions.assertEquals((int)2, (int)e.getChildrenCount(Leaf.class));
    }

    @Test
    public void testGetText() {
        Element e = new Element(NAME);
        Assertions.assertEquals(null, (Object)e.getText());
        e.addComment("Hello");
        Assertions.assertEquals(null, (Object)e.getText());
        e.removeChildAt(0);
        Assertions.assertEquals(null, (Object)e.getText());
        e.addComment("Comment");
        e.addText("Hello");
        Assertions.assertEquals((Object)"Hello", (Object)e.getText());
        e.addText("World");
        Assertions.assertEquals((Object)"HelloWorld", (Object)e.getText());
        e.addElement("Child");
        Assertions.assertEquals(null, (Object)e.getText());
        e.removeChildren();
        e.addText("Hello", false);
        e.addComment("Comment");
        e.addText("World", false);
        Assertions.assertEquals((Object)"HelloWorld", (Object)e.getText());
        e.removeChildren();
        e.addText("true");
        Assertions.assertEquals((Object)true, (Object)e.getTextAsBoolean(false));
        Assertions.assertEquals((Object)true, (Object)e.getTextAsOptionalBoolean(null));
        e.removeChildren();
        e.addText("10");
        Assertions.assertEquals((long)10L, (long)e.getTextAsLong(0L));
        Assertions.assertEquals((Object)10L, (Object)e.getTextAsOptionalLong(null));
        Assertions.assertEquals((int)10, (int)e.getTextAsInt(0));
        Assertions.assertEquals((Object)10, (Object)e.getTextAsOptionalInt(null));
        Assertions.assertEquals((short)10, (short)e.getTextAsShort((short)0));
        Assertions.assertEquals((Object)10, (Object)e.getTextAsOptionalShort(null));
        Assertions.assertEquals((byte)10, (byte)e.getTextAsByte((byte)0));
        Assertions.assertEquals((Object)10, (Object)e.getTextAsOptionalByte(null));
    }

    @Test
    public void testRemoveChildren1() {
        Element root = new Element(NAME);
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME2);
        Element child3 = root.addElement(NAME3);
        Assertions.assertEquals((Object)child1, (Object)root.getChildAt(0));
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(1));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(2));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME3)));
        root.removeChildAt(0);
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(0));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(1));
        Assertions.assertEquals((int)0, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME3)));
        root.removeChildAt(0);
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(0));
        Assertions.assertEquals((int)0, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((int)0, (int)root.getChildrenCount(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME3)));
        root.removeChildAt(0);
        root.addChild((Child)child1);
        root.addChild((Child)child2);
        root.addChild((Child)child3);
        Assertions.assertEquals((Object)child1, (Object)root.getChildAt(0));
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(1));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(2));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME3)));
        root.removeChildAt(2);
        Assertions.assertEquals((Object)child1, (Object)root.getChildAt(0));
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(1));
        root.removeChildAt(0);
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(0));
    }

    @Test
    public void testRemoveChildren2() {
        Element root = new Element(NAME);
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME1);
        Element child3 = root.addElement(NAME3);
        Element child4 = root.addElement(NAME4);
        Element child5 = root.addElement(NAME1);
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((int)0, (int)root.getChildrenCount(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((int)5, (int)root.getChildrenCount(Element.class));
        Assertions.assertEquals((Object)child1, (Object)root.getChildAt(0));
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(1));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(2));
        Assertions.assertEquals((Object)child4, (Object)root.getChildAt(3));
        Assertions.assertEquals((Object)child5, (Object)root.getChildAt(4));
        root.removeChildAt(0);
        Assertions.assertEquals((int)2, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((int)0, (int)root.getChildrenCount(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((int)4, (int)root.getChildrenCount(Element.class));
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(0));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(1));
        Assertions.assertEquals((Object)child4, (Object)root.getChildAt(2));
        Assertions.assertEquals((Object)child5, (Object)root.getChildAt(3));
        root.removeChildAt(3);
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((int)0, (int)root.getChildrenCount(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Element.class));
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(0));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(1));
        Assertions.assertEquals((Object)child4, (Object)root.getChildAt(2));
        root.removeChildAt(2);
        root.removeChildAt(0);
    }

    @Test
    public void testRemoveChildren() {
        Element root = new Element(NAME);
        root.addElement(NAME1);
        root.addElement(NAME1);
        root.addElement(NAME2);
        root.addElement(NAME1);
        root.addElement(NAME1);
        Assertions.assertEquals((int)5, (int)root.getChildrenCount(Element.class));
        Assertions.assertEquals((int)4, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        root.removeChildAt(0);
        Assertions.assertEquals((int)4, (int)root.getChildrenCount(Element.class));
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        root.removeElementsNamed(NAME1);
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Element.class));
        Assertions.assertEquals((int)0, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
    }
}

