/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.Attribute;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.NodeType;
import cdc.util.data.Text;
import java.util.Comparator;
import java.util.function.Predicate;

public interface Node {
    public static final Predicate<Node> ANY_NODE = n -> true;
    public static final Predicate<Node> IS_COMMENT = node -> node.getType() == NodeType.COMMENT;
    public static final Predicate<Node> IS_ELEMENT = node -> node.getType() == NodeType.ELEMENT;
    public static final Predicate<Node> IS_TEXT = node -> node.getType() == NodeType.TEXT;
    public static final Predicate<Node> IS_PURE_ELEMENT = node -> {
        if (node.getType() == NodeType.ELEMENT) {
            Element element = (Element)node;
            return !element.hasAttributes() && !element.hasChildren();
        }
        return false;
    };
    public static final Predicate<Node> IS_IGNORABLE_TEXT = node -> {
        if (node.getType() == NodeType.TEXT) {
            Text text = (Text)node;
            return text.isIgnorable();
        }
        return false;
    };
    public static final Comparator<Node> ELEMENT_NAME_COMPARATOR = (node1, node2) -> {
        if (node1 instanceof Element && node2 instanceof Element) {
            return ((Element)node1).getName().compareTo(((Element)node2).getName());
        }
        throw new IllegalArgumentException();
    };
    public static final Comparator<Node> ELEMENT_NAME_AND_ATTRIBUTES_COMPARATOR = (node1, node2) -> {
        if (node1 instanceof Element && node2 instanceof Element) {
            return Node.getNameAndAttributes((Element)node1).compareTo(Node.getNameAndAttributes((Element)node2));
        }
        throw new IllegalArgumentException();
    };

    public static String getNameAndAttributes(Element element) {
        StringBuilder builder = new StringBuilder();
        builder.append(element.getName());
        for (Attribute att : element.getSortedAttributes()) {
            builder.append(':');
            builder.append(att.getName());
            builder.append('=');
            builder.append(att.getValue());
        }
        return builder.toString();
    }

    public NodeType getType();

    public Node clone(boolean var1);

    public boolean deepEquals(Node var1);

    public Document getDocument();

    public Element getRootElement();

    public String getQName();
}

