/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Element;
import cdc.util.data.paths.SPath;
import cdc.util.lang.Checks;
import java.util.Collection;

@FunctionalInterface
public interface AttributePredicate {
    public static final AttributePredicate ANY_ATTRIBUTE = (e, n, v) -> true;
    public static final AttributePredicate IS_EMPTY_ATTRIBUTE = (e, n, v) -> v == null || v.isEmpty();
    public static final AttributePredicate IS_NOT_EMPTY_ATTRIBUTE = IS_EMPTY_ATTRIBUTE.not();

    public boolean accepts(Element var1, String var2, String var3);

    default public AttributePredicate not() {
        return (e, n, v) -> !this.accepts(e, n, v);
    }

    default public AttributePredicate and(AttributePredicate other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (e, n, v) -> this.accepts(e, n, v) && other.accepts(e, n, v);
    }

    default public AttributePredicate or(AttributePredicate other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (e, n, v) -> this.accepts(e, n, v) || other.accepts(e, n, v);
    }

    public static AttributePredicate fromNames(Collection<String> names) {
        Checks.isNotNull(names, (String)"names");
        return (element, name, value) -> names.contains(name);
    }

    public static AttributePredicate fromPaths(Collection<SPath> paths) {
        Checks.isNotNull(paths, (String)"paths");
        return (element, name, value) -> {
            for (SPath path : paths) {
                if (!path.matchesAttribute(element, name)) continue;
                return true;
            }
            return false;
        };
    }
}

