/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Element;
import cdc.util.data.Parent;
import cdc.util.data.paths.SPath;
import cdc.util.lang.Checks;
import cdc.util.strings.StringUtil;
import java.util.Map;
import java.util.function.Function;

@FunctionalInterface
public interface TextContentConverter {
    public static final TextContentConverter IDENTITY = (p, c) -> c;

    public String convertTextContent(Parent var1, String var2);

    default public TextContentConverter compose(TextContentConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (parent, content) -> this.convertTextContent(parent, other.convertTextContent(parent, content));
    }

    default public TextContentConverter andThen(TextContentConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (parent, content) -> other.convertTextContent(parent, this.convertTextContent(parent, content));
    }

    public static TextContentConverter fromString(String s) {
        return (parent, content) -> s;
    }

    public static TextContentConverter scramble(boolean preserveSpaces) {
        return (parent, content) -> StringUtil.scrambleWithLettersOrDigits((String)content, (boolean)preserveSpaces);
    }

    public static TextContentConverter fromContentFunction(Function<String, String> function) {
        Checks.isNotNull(function, (String)"function");
        return (parent, content) -> (String)function.apply(content);
    }

    public static TextContentConverter fromContentMap(Map<String, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (parent, content) -> map.getOrDefault(content, content);
    }

    public static TextContentConverter fromNameMap(Map<String, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (parent, content) -> parent instanceof Element ? map.getOrDefault(((Element)parent).getName(), content) : content;
    }

    public static TextContentConverter fromPathMap(Map<SPath, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (parent, content) -> {
            for (Map.Entry entry : map.entrySet()) {
                if (!((SPath)entry.getKey()).matchesElement(parent)) continue;
                return (String)entry.getValue();
            }
            return content;
        };
    }
}

