/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.xml;

import cdc.util.data.Attribute;
import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Text;
import cdc.util.xml.XmlWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XmlDataWriter
implements Closeable,
Flushable {
    protected static final Logger LOGGER = LogManager.getLogger(XmlDataWriter.class);
    private final XmlWriter writer;

    public XmlDataWriter(XmlWriter writer) {
        this.writer = writer;
    }

    public XmlDataWriter(Writer writer) {
        this.writer = new XmlWriter(writer);
    }

    public XmlDataWriter(OutputStream os) throws UnsupportedEncodingException {
        this(os, StandardCharsets.UTF_8.name());
    }

    public XmlDataWriter(OutputStream os, String encoding) throws UnsupportedEncodingException {
        this.writer = new XmlWriter(os, encoding);
    }

    public XmlDataWriter(PrintStream out) throws UnsupportedEncodingException {
        this(out, StandardCharsets.UTF_8.name());
    }

    public XmlDataWriter(PrintStream out, String encoding) throws UnsupportedEncodingException {
        this.writer = new XmlWriter((OutputStream)out, encoding);
    }

    public XmlDataWriter(String filename) throws FileNotFoundException, UnsupportedEncodingException {
        this(filename, StandardCharsets.UTF_8.name());
    }

    public XmlDataWriter(String filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this.writer = new XmlWriter(filename, encoding);
    }

    public XmlDataWriter(File file) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, StandardCharsets.UTF_8.name());
    }

    public XmlDataWriter(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this.writer = new XmlWriter(file, encoding);
    }

    public final XmlWriter getXmlWriter() {
        return this.writer;
    }

    public void write(Node node) throws IOException {
        XmlDataWriter.write(this.writer, node);
    }

    public static void write(XmlWriter writer, Node node, boolean asDocument) throws IOException {
        if (!asDocument || node instanceof Document) {
            XmlDataWriter.write(writer, node);
        } else {
            writer.beginDocument();
            XmlDataWriter.write(writer, node);
            writer.endDocument();
        }
    }

    public static void write(XmlWriter writer, Node node) throws IOException {
        switch (node.getType()) {
            case COMMENT: {
                Comment comment = (Comment)node;
                writer.addComment(comment.getContent());
                break;
            }
            case DOCUMENT: {
                Document document = (Document)node;
                writer.beginDocument();
                for (Child child : document.getChildren()) {
                    XmlDataWriter.write(writer, child);
                }
                writer.endDocument();
                break;
            }
            case ELEMENT: {
                Element element = (Element)node;
                writer.beginElement(element.getName());
                for (Attribute attribute : element.getAttributes()) {
                    writer.addAttribute(attribute.getName(), attribute.getValue());
                }
                if (element.hasChildren(Text.class)) {
                    writer.addElementContent("");
                }
                for (Child child : element.getChildren()) {
                    XmlDataWriter.write(writer, child);
                }
                writer.endElement();
                break;
            }
            case TEXT: {
                Text text = (Text)node;
                writer.addElementContent(text.getContent());
                break;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    private void write(Node node, boolean asDocument, String indent, XmlWriter.Feature ... features) throws IOException {
        this.getXmlWriter().setEnabled(features);
        if (indent != null) {
            this.getXmlWriter().setEnabled(XmlWriter.Feature.PRETTY_PRINT, true);
        }
        if (!asDocument) {
            this.getXmlWriter().setEnabled(XmlWriter.Feature.ALLOW_PARTIAL_XML, true);
        }
        this.getXmlWriter().setIndentString(indent);
        XmlDataWriter.write(this.writer, node, asDocument);
        this.writer.flush();
    }

    public static void print(Node node, boolean asDocument, PrintStream out, String indent, boolean close, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter writer = new XmlDataWriter(out);
        writer.write(node, asDocument, indent, features);
        if (close) {
            writer.close();
        }
    }

    public static void print(Document doc, PrintStream out, String indent, boolean close, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter.print((Node)doc, false, out, indent, close, features);
    }

    public static void save(Node node, boolean asDocument, Writer writer, String indent, XmlWriter.Feature ... features) throws IOException {
        try (XmlDataWriter w = new XmlDataWriter(writer);){
            w.write(node, asDocument, indent, features);
        }
    }

    public static void save(Document doc, Writer writer, String indent, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter.save((Node)doc, false, writer, indent, features);
    }

    public static void save(Node node, boolean asDocument, OutputStream os, String indent, XmlWriter.Feature ... features) throws IOException {
        try (XmlDataWriter writer = new XmlDataWriter(os);){
            writer.write(node, asDocument, indent, features);
        }
    }

    public static void save(Document doc, OutputStream os, String indent, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter.save((Node)doc, false, os, indent, features);
    }

    public static void save(Node node, boolean asDocument, String filename, String indent, XmlWriter.Feature ... features) throws IOException {
        try (XmlDataWriter writer = new XmlDataWriter(filename);){
            writer.write(node, asDocument, indent, features);
        }
    }

    public static void save(Document doc, String filename, String indent, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter.save((Node)doc, false, filename, indent, features);
    }

    public static void save(Node node, boolean asDocument, File file, String indent, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter.save(node, asDocument, file.getPath(), indent, features);
    }

    public static void save(Document doc, File file, String indent, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter.save((Node)doc, false, file, indent, features);
    }

    public static String toString(Document doc, String indent, XmlWriter.Feature ... features) {
        String string;
        StringWriter writer = new StringWriter();
        Throwable throwable = null;
        try {
            XmlDataWriter.save(doc, writer, indent, features);
            string = writer.toString();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    XmlDataWriter.$closeResource(throwable, writer);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                LOGGER.catching((Throwable)e);
                return null;
            }
        }
        XmlDataWriter.$closeResource(throwable, writer);
        return string;
    }

    public static String toString(Node node, boolean asDocument, String indent, XmlWriter.Feature ... features) {
        String string;
        StringWriter writer = new StringWriter();
        Throwable throwable = null;
        try {
            XmlDataWriter.save(node, asDocument, writer, indent, features);
            string = writer.toString();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    XmlDataWriter.$closeResource(throwable, writer);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                LOGGER.catching((Throwable)e);
                return null;
            }
        }
        XmlDataWriter.$closeResource(throwable, writer);
        return string;
    }
}

