package cdc.util.data;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

import cdc.util.strings.StringUtil;

public final class Nodes {

    private Nodes() {
    }

    public static void print(Node node,
                             Logger logger,
                             Level level) {
        print(node, logger, level, 0);

    }

    private static void print(Node node,
                              Logger logger,
                              Level level,
                              int depth) {
        logger.log(level, indent(depth) + toString(node));
        if (node instanceof Parent) {
            final Parent parent = (Parent) node;
            for (final Node child : parent.getChildren()) {
                print(child, logger, level, depth + 1);
            }
        }
    }

    private static String indent(int depth) {
        return StringUtil.toString(' ', depth * 3);
    }

    private static String toString(Node node) {
        final StringBuilder builder = new StringBuilder();
        builder.append(node.getType());
        switch (node.getType()) {
        case COMMENT:
        case TEXT:
            builder.append(" '" + StringUtil.extract(((AbstractContentNode) node).getContent(), 10) + "'");
            break;
        case ELEMENT:
            builder.append(" " + ((Element) node).getName());
            break;
        default:
            break;
        }

        return builder.toString();
    }
}