package cdc.util.data.util;

import java.io.PrintStream;

import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;

public class DataStats {
    private final int[] counts = new int[NodeType.values().length];
    private int atts = 0;

    public DataStats(Node node) {
        count(node);
    }

    public int getNodesCount(NodeType type) {
        return counts[type.ordinal()];
    }

    public int getAttributesCount() {
        return atts;
    }

    public void print(PrintStream out) {
        for (final NodeType type : NodeType.values()) {
            out.println(type.name() + ": " + getNodesCount(type));
        }
        out.println("ATTRIBUTES: " + getAttributesCount());
    }

    public static void print(Node node,
                             PrintStream out) {
        final DataStats stats = new DataStats(node);
        stats.print(out);
    }

    private void count(Node node) {
        counts[node.getType().ordinal()]++;
        if (node instanceof Element) {
            atts += ((Element) node).getAttributesCount();
        }
        if (node instanceof Parent) {
            for (final Node child : ((Parent) node).getChildren()) {
                count(child);
            }
        }
    }
}