/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Attribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AttributeTest {
    private static final String NAME = "name";

    @Test
    public void testMisc() {
        Attribute att = new Attribute(NAME);
        Assertions.assertEquals((Object)att, (Object)att);
        Assertions.assertEquals((Object)NAME, (Object)att.getName());
        Attribute att2 = new Attribute(att);
        Assertions.assertEquals((Object)att, (Object)att2);
        att2.setValue("XXX");
        Assertions.assertNotEquals((Object)att, (Object)att2);
        Assertions.assertNotEquals((Object)att, (Object)new Attribute("NAME"));
    }

    @Test
    public void testObject() {
        Attribute att1 = new Attribute(NAME, null);
        Assertions.assertEquals(null, (Object)att1.getValue());
        Attribute att2 = new Attribute(NAME, this.getClass());
        Assertions.assertEquals((Object)this.getClass().toString(), (Object)att2.getValue());
    }

    @Test
    public void testString() {
        Attribute att = new Attribute(NAME, "SSS");
        Assertions.assertEquals((Object)"SSS", (Object)att.getValue());
    }

    @Test
    public void testBoolean() {
        Attribute att = new Attribute(NAME, true);
        Assertions.assertTrue((boolean)att.getValueAsBoolean());
        Assertions.assertEquals((Object)"true", (Object)att.getValue());
    }

    @Test
    public void testByte() {
        Attribute att = new Attribute(NAME, 10);
        Assertions.assertEquals((byte)10, (byte)att.getValueAsByte());
        Assertions.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testShort() {
        Attribute att = new Attribute(NAME, 10);
        Assertions.assertEquals((short)10, (short)att.getValueAsShort());
        Assertions.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testInteger() {
        Attribute att = new Attribute(NAME, 10);
        Assertions.assertEquals((int)10, (int)att.getValueAsInt());
        Assertions.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testLong() {
        Attribute att = new Attribute(NAME, 10L);
        Assertions.assertEquals((long)10L, (long)att.getValueAsLong());
        Assertions.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testFloat() {
        Attribute att = new Attribute(NAME, 10.0f);
        Assertions.assertEquals((double)10.0, (double)att.getValueAsFloat(), (double)1.0E-10);
        Assertions.assertEquals((Object)"10.0", (Object)att.getValue());
    }

    @Test
    public void testDouble() {
        Attribute att = new Attribute(NAME, 10.0);
        Assertions.assertEquals((double)10.0, (double)att.getValueAsDouble(), (double)1.0E-10);
        Assertions.assertEquals((Object)"10.0", (Object)att.getValue());
    }

    @Test
    public void testEnum() {
        Attribute att = new Attribute(NAME, (java.lang.Enum)Enum.A);
        Assertions.assertEquals((Object)((Object)Enum.A), (Object)att.getValueAsEnum(Enum.class));
        Assertions.assertEquals((Object)Enum.A.name(), (Object)att.getValue());
    }

    private static enum Enum {
        A,
        B;

    }
}

