/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.AbstractContentNode;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Parent;
import cdc.util.strings.StringUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public final class Nodes {
    private Nodes() {
    }

    public static void print(Node node, Logger logger, Level level) {
        Nodes.print(node, logger, level, 0);
    }

    private static void print(Node node, Logger logger, Level level, int depth) {
        logger.log(level, Nodes.indent(depth) + Nodes.toString(node));
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node node2 : parent.getChildren()) {
                Nodes.print(node2, logger, level, depth + 1);
            }
        }
    }

    private static String indent(int depth) {
        return StringUtil.toString((char)' ', (int)(depth * 3));
    }

    private static String toString(Node node) {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)node.getType());
        switch (node.getType()) {
            case COMMENT: 
            case TEXT: {
                builder.append(" '" + StringUtil.extract((String)((AbstractContentNode)node).getContent(), (int)10) + "'");
                break;
            }
            case ELEMENT: {
                builder.append(" " + ((Element)node).getName());
                break;
            }
        }
        return builder.toString();
    }
}

