/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.compress.Compressor;
import cdc.util.data.DataException;
import cdc.util.data.Element;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.lang.FailureReaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractResourceLoader<R> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final FailureReaction reaction;

    public AbstractResourceLoader(FailureReaction reaction) {
        this.reaction = reaction;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final FailureReaction getReaction() {
        return this.reaction;
    }

    public final R loadXml(File file, Compressor compressor, XmlDataReader.Feature ... features) throws IOException {
        this.logger.info("loadXml(" + file + ", " + compressor + ")");
        Element root = XmlDataReader.loadRoot(file, compressor, features);
        return this.loadRoot(root);
    }

    public final R loadXml(File file, XmlDataReader.Feature ... features) throws IOException {
        return this.loadXml(file, Compressor.NONE, features);
    }

    public final R loadXml(String filename, Compressor compressor, XmlDataReader.Feature ... features) throws IOException {
        this.logger.info("loadXml(" + filename + ", " + compressor + ")");
        Element root = XmlDataReader.loadRoot(filename, compressor, features);
        return this.loadRoot(root);
    }

    public final R loadXml(String filename, XmlDataReader.Feature ... features) throws IOException {
        return this.loadXml(filename, Compressor.NONE, features);
    }

    public final R loadXml(URL url, Compressor compressor, XmlDataReader.Feature ... features) throws IOException {
        this.logger.info("loadXml(" + url + ", " + compressor + ")");
        Element root = XmlDataReader.loadRoot(url, compressor, features);
        return this.loadRoot(root);
    }

    public final R loadXml(URL url, XmlDataReader.Feature ... features) throws IOException {
        return this.loadXml(url, Compressor.NONE, features);
    }

    public final void loadXml(List<URL> urls, Compressor compressor, XmlDataReader.Feature ... features) {
        for (URL url : urls) {
            try {
                this.loadXml(url, compressor, features);
            }
            catch (IOException e) {
                this.logger.catching((Throwable)e);
            }
        }
    }

    public final void loadXml(List<URL> urls, XmlDataReader.Feature ... features) {
        this.loadXml(urls, Compressor.NONE, features);
    }

    public final R loadXml(InputStream is, String systemId, XmlDataReader.Feature ... features) throws IOException {
        this.logger.info("loadXml(" + systemId + ")");
        Element root = XmlDataReader.loadRoot(is, systemId, features);
        return this.loadRoot(root);
    }

    protected abstract R loadRoot(Element var1);

    protected final void onError(String message) {
        FailureReaction.onError((String)message, (Logger)this.logger, (FailureReaction)this.reaction, DataException::new);
    }

    protected final <T> T onError(String message, T def) {
        return (T)FailureReaction.onError((String)message, (Logger)this.logger, (FailureReaction)this.reaction, def, DataException::new);
    }

    protected final <T> T onResult(T result, String message, T def) {
        return (T)FailureReaction.onResult(result, (String)message, (Logger)this.logger, (FailureReaction)this.reaction, def, DataException::new);
    }

    protected final void unexpectedElement(Element element, String ... expected) {
        this.unexpectedElement(element, (Object)null, expected);
    }

    protected final <V> V unexpectedElement(Element element, V def, String ... expected) {
        if (expected == null || expected.length == 0) {
            return this.onError("Unexpected child " + element + " under " + element.getParent(), def);
        }
        return this.onError("Unexpected child " + element + " under " + element.getParent() + " expected one of " + Arrays.toString(expected), def);
    }
}

