/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Element;
import cdc.util.data.Parent;
import cdc.util.data.paths.SPath;
import cdc.util.lang.Checks;
import java.util.Collection;
import java.util.function.Predicate;

@FunctionalInterface
public interface ElementPredicate {
    public static final ElementPredicate ANY_ELEMENT = (p, e) -> true;
    public static final ElementPredicate EMPTY_ELEMENT = (p, e) -> e.isEmpty();
    public static final ElementPredicate PURE_ELEMENT = (p, e) -> e.isPure();

    public boolean accepts(Parent var1, Element var2);

    default public ElementPredicate not() {
        return (p, e) -> !this.accepts(p, e);
    }

    default public ElementPredicate and(ElementPredicate other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (p, e) -> this.accepts(p, e) && other.accepts(p, e);
    }

    default public ElementPredicate or(ElementPredicate other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (p, e) -> this.accepts(p, e) || other.accepts(p, e);
    }

    public static ElementPredicate fromNames(Collection<String> names) {
        Checks.isNotNull(names, (String)"names");
        return (parent, element) -> names.contains(element.getName());
    }

    public static ElementPredicate fromPaths(Collection<SPath> paths) {
        Checks.isNotNull(paths, (String)"paths");
        return (parent, element) -> {
            for (SPath path : paths) {
                if (!path.matchesElement(parent, element.getName())) continue;
                return true;
            }
            return false;
        };
    }

    public static ElementPredicate fromPredicate(Predicate<Element> predicate) {
        Checks.isNotNull(predicate, (String)"predicate");
        return (parent, element) -> predicate.test(element);
    }
}

