/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.xml;

import cdc.util.compress.CompressionUtil;
import cdc.util.compress.Compressor;
import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import cdc.util.data.util.AttributeNameConverter;
import cdc.util.data.util.AttributePredicate;
import cdc.util.data.util.AttributeValueConverter;
import cdc.util.data.util.ElementNameConverter;
import cdc.util.data.util.ElementPredicate;
import cdc.util.data.util.TextContentConverter;
import cdc.util.lang.Cache;
import cdc.util.lang.Checks;
import cdc.util.lang.IntMasks;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class XmlDataReader {
    public static final Cache<String> CACHE = new Cache(String.class, (s1, s2) -> s1.compareTo((String)s2));
    protected static final Logger LOGGER = LogManager.getLogger(XmlDataReader.class);
    private int features = 0;
    protected EntityResolver entityResolver = null;
    protected AttributePredicate attributeFilter = AttributePredicate.ANY_ATTRIBUTE;
    protected AttributeNameConverter attributeNameConverter = AttributeNameConverter.IDENTITY;
    protected AttributeValueConverter attributeValueConverter = AttributeValueConverter.INDENTITY;
    protected ElementPredicate elementPreFilter = ElementPredicate.ANY_ELEMENT;
    protected ElementPredicate elementPostFilter = ElementPredicate.ANY_ELEMENT;
    protected ElementNameConverter elementNameConverter = ElementNameConverter.IDENTITY;
    protected TextContentConverter textContentConverter = TextContentConverter.IDENTITY;
    private static final String FILTER = "filter";
    private static final String CONVERTER = "converter";

    public XmlDataReader() {
    }

    public XmlDataReader(Feature ... features) {
        for (Feature feature : features) {
            this.setEnabled(feature, true);
        }
    }

    public final boolean isEnabled(Feature feature) {
        return IntMasks.isEnabled((int)this.features, (Enum)feature);
    }

    public final void setEnabled(Feature feature, boolean enabled) {
        this.features = IntMasks.setEnabled((int)this.features, (Enum)feature, (boolean)enabled);
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public AttributePredicate getAttributeFilter() {
        return this.attributeFilter;
    }

    public void setAttributeFilter(AttributePredicate filter) {
        Checks.isNotNull((Object)filter, (String)FILTER);
        this.attributeFilter = filter;
    }

    public AttributeNameConverter getAttributeNameConverter() {
        return this.attributeNameConverter;
    }

    public void setAttributeNameConverter(AttributeNameConverter converter) {
        Checks.isNotNull((Object)converter, (String)CONVERTER);
        this.attributeNameConverter = converter;
    }

    public AttributeValueConverter getAttributeValueConverter() {
        return this.attributeValueConverter;
    }

    public void setAttributeValueConverter(AttributeValueConverter converter) {
        Checks.isNotNull((Object)converter, (String)CONVERTER);
        this.attributeValueConverter = converter;
    }

    public ElementPredicate getElementPreFilter() {
        return this.elementPreFilter;
    }

    public void setElementPreFilter(ElementPredicate filter) {
        Checks.isNotNull((Object)filter, (String)FILTER);
        this.elementPreFilter = filter;
    }

    public ElementPredicate getElementPostFilter() {
        return this.elementPostFilter;
    }

    public void setElementPostFilter(ElementPredicate filter) {
        Checks.isNotNull((Object)filter, (String)FILTER);
        this.elementPostFilter = filter;
    }

    public ElementNameConverter getElementNameConverter() {
        return this.elementNameConverter;
    }

    public void setElementNameConverter(ElementNameConverter converter) {
        Checks.isNotNull((Object)converter, (String)CONVERTER);
        this.elementNameConverter = converter;
    }

    public TextContentConverter getTextContentConverter() {
        return this.textContentConverter;
    }

    public void setTextContentConverter(TextContentConverter converter) {
        Checks.isNotNull((Object)converter, (String)CONVERTER);
        this.textContentConverter = converter;
    }

    private XMLReader configureReader(SAXParser parser, Handler handler) throws SAXException {
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setDTDHandler(handler);
        if (this.isEnabled(Feature.LOAD_COMMENTS)) {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        if (this.isEnabled(Feature.DUMMY_ENTITY_RESOLVER)) {
            reader.setEntityResolver(new DummyEntityResolver());
        }
        if (this.getEntityResolver() != null) {
            if (this.isEnabled(Feature.DUMMY_ENTITY_RESOLVER)) {
                LOGGER.warn("Dummy entity resolver overwritten by user defined one");
            }
            reader.setEntityResolver(this.getEntityResolver());
        }
        return reader;
    }

    public Document read(InputStream is) throws IOException {
        LOGGER.debug("read(is=...)");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Handler handler = new Handler();
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = this.configureReader(parser, handler);
            InputSource source = new InputSource(is);
            reader.parse(source);
            return handler.getDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.trace((Object)e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return null;
    }

    public Element readRoot(InputStream is) throws IOException {
        return Document.getRootElement(this.read(is));
    }

    public Document read(InputStream is, String systemId) throws IOException {
        LOGGER.debug("read(is=..., " + systemId + ")");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Handler handler = new Handler();
        try {
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = this.configureReader(parser, handler);
            InputSource source = new InputSource(is);
            source.setSystemId(systemId);
            reader.parse(source);
            return handler.getDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.trace((Object)e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return null;
    }

    public Element readRoot(InputStream is, String systemId) throws IOException {
        return Document.getRootElement(this.read(is, systemId));
    }

    public Document read(String s, Charset charset) throws IOException {
        return this.read(new ByteArrayInputStream(s.getBytes(charset)));
    }

    public Element readRoot(String s, Charset charset) throws IOException {
        return Document.getRootElement(this.read(s, charset));
    }

    public Document read(URL url, Compressor compressor) throws IOException {
        LOGGER.debug("read(url=" + url + ", " + compressor + ")");
        try (InputStream is = CompressionUtil.adapt((InputStream)url.openStream(), (Compressor)compressor);){
            Document document = this.read(is);
            return document;
        }
    }

    public Document read(URL url) throws IOException {
        return this.read(url, Compressor.NONE);
    }

    public Element readRoot(URL url, Compressor compressor) throws IOException {
        return Document.getRootElement(this.read(url, compressor));
    }

    public Element readRoot(URL url) throws IOException {
        return this.readRoot(url, Compressor.NONE);
    }

    public Document read(String filename, Compressor compressor) throws IOException {
        LOGGER.debug("read(filename=" + filename + ", " + compressor + ")");
        try (BufferedInputStream is = new BufferedInputStream(CompressionUtil.adapt((InputStream)new FileInputStream(filename), (Compressor)compressor));){
            Document document = this.read(is, filename);
            return document;
        }
    }

    public Document read(String filename) throws IOException {
        return this.read(filename, Compressor.NONE);
    }

    public Element readRoot(String filename, Compressor compressor) throws IOException {
        return Document.getRootElement(this.read(filename, compressor));
    }

    public Element readRoot(String filename) throws IOException {
        return this.readRoot(filename, Compressor.NONE);
    }

    public Document read(File file, Compressor compressor) throws IOException {
        LOGGER.debug("read(file=" + file + ", " + compressor + ")");
        return this.read(file.getPath(), compressor);
    }

    public Document read(File file) throws IOException {
        return this.read(file.getPath(), Compressor.NONE);
    }

    public Element readRoot(File file, Compressor compressor) throws IOException {
        return Document.getRootElement(this.read(file, compressor));
    }

    public Element readRoot(File file) throws IOException {
        return this.readRoot(file, Compressor.NONE);
    }

    public static XmlDataReader create(Feature ... features) {
        XmlDataReader reader = new XmlDataReader();
        for (Feature feature : features) {
            reader.setEnabled(feature, true);
        }
        return reader;
    }

    public static Document load(InputStream is, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(is);
    }

    public static Element loadRoot(InputStream is, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(is);
    }

    public static Document load(InputStream is, String systemId, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(is, systemId);
    }

    public static Element loadRoot(InputStream is, String systemId, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(is, systemId);
    }

    public static Document load(String s, Charset charset, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(s, charset);
    }

    public static Element loadRoot(String s, Charset charset, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(s, charset);
    }

    public static Document load(URL url, Compressor compressor, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(url, compressor);
    }

    public static Document load(URL url, Feature ... features) throws IOException {
        return XmlDataReader.load(url, Compressor.NONE, features);
    }

    public static Element loadRoot(URL url, Compressor compressor, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(url, compressor);
    }

    public static Element loadRoot(URL url, Feature ... features) throws IOException {
        return XmlDataReader.loadRoot(url, Compressor.NONE, features);
    }

    public static Document load(String filename, Compressor compressor, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(filename, compressor);
    }

    public static Document load(String filename, Feature ... features) throws IOException {
        return XmlDataReader.load(filename, Compressor.NONE, features);
    }

    public static Element loadRoot(String filename, Compressor compressor, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(filename, compressor);
    }

    public static Element loadRoot(String filename, Feature ... features) throws IOException {
        return XmlDataReader.loadRoot(filename, Compressor.NONE, features);
    }

    public static Document load(File file, Compressor compressor, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(file, compressor);
    }

    public static Document load(File file, Feature ... features) throws IOException {
        return XmlDataReader.load(file, Compressor.NONE, features);
    }

    public static Element loadRoot(File file, Compressor compressor, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(file, compressor);
    }

    public static Element loadRoot(File file, Feature ... features) throws IOException {
        return XmlDataReader.loadRoot(file, Compressor.NONE, features);
    }

    private class Handler
    extends DefaultHandler2 {
        private Locator locator = null;
        private Document document = null;
        private Parent currentParent = null;
        private Text activeText = null;
        private Context context = new Context(null);

        private void resetActiveText() {
            if (this.activeText != null) {
                this.activeText.setContent(XmlDataReader.this.textContentConverter.convertTextContent(this.activeText.getParent(), this.activeText.getContent()));
                this.activeText = null;
            }
        }

        private void checkActiveText(boolean preserve) throws SAXException {
            if (this.activeText != null) {
                if (preserve && this.currentParent.getChildrenCount() == 1) {
                    this.resetActiveText();
                } else if (this.activeText.getContent().isEmpty() || this.activeText.isIgnorable() && !XmlDataReader.this.isEnabled(Feature.LOAD_SPACES)) {
                    this.currentParent.removeChildAt(this.currentParent.getChildrenCount() - 1);
                    this.resetActiveText();
                } else if (this.currentParent.getChildrenCount() > 1 && !XmlDataReader.this.isEnabled(Feature.ALLOW_MIXED_CONTENT)) {
                    throw new SAXException("Mixed content not allowed");
                }
            }
        }

        private boolean currentParentHasCloseTextChild() {
            List<? extends Child> children = this.currentParent.getChildren();
            for (int index = children.size() - 1; index >= 0; --index) {
                Child child = children.get(index);
                if (child.getType() == NodeType.ELEMENT) {
                    return false;
                }
                if (child.getType() != NodeType.TEXT) continue;
                return true;
            }
            return false;
        }

        public Document getDocument() {
            return this.document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            LOGGER.trace("startDocument()");
            this.document = new Document();
            this.currentParent = this.document;
            this.resetActiveText();
        }

        @Override
        public void endDocument() throws SAXException {
            LOGGER.trace("endDocument()");
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        private final boolean acceptsAttribute(Element element, String name, String value) {
            return XmlDataReader.this.attributeFilter.accepts(element, name, value);
        }

        private String shareAttributeName(String name) {
            if (XmlDataReader.this.isEnabled(Feature.SHARE_ATTRIBUTE_NAMES)) {
                return (String)CACHE.get((Object)name);
            }
            return name;
        }

        private final String convertAttributeName(Element element, String name) {
            return this.shareAttributeName(XmlDataReader.this.attributeNameConverter.convertAttributeName(element, name));
        }

        private final String convertAttributeValue(Element element, String name, String value) {
            return XmlDataReader.this.attributeValueConverter.convertAttributeValue(element, name, value);
        }

        private final boolean acceptsElementPre(Parent parent, Element element) {
            return XmlDataReader.this.elementPreFilter.accepts(parent, element);
        }

        private final boolean acceptsElementPost(Parent parent, Element element) {
            return XmlDataReader.this.elementPostFilter.accepts(parent, element);
        }

        private String shareElementName(String name) {
            if (XmlDataReader.this.isEnabled(Feature.SHARE_ELEMENT_NAMES)) {
                return (String)CACHE.get((Object)name);
            }
            return name;
        }

        private final String convertElementName(Parent parent, String name) {
            return this.shareElementName(XmlDataReader.this.elementNameConverter.convertElementName(parent, name));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            LOGGER.trace("startElement()");
            if (this.context.action == Action.KEEP) {
                this.checkActiveText(false);
                if (!XmlDataReader.this.isEnabled(Feature.ALLOW_MIXED_CONTENT) && this.currentParentHasCloseTextChild()) {
                    throw new SAXException("Mixed content not allowed");
                }
                Element element = new Element(this.convertElementName(this.currentParent, qName));
                for (int index = 0; index < atts.getLength(); ++index) {
                    String value;
                    String name = atts.getQName(index);
                    if (!this.acceptsAttribute(element, name, value = atts.getValue(index))) continue;
                    element.addAttribute(this.convertAttributeName(element, name), this.convertAttributeValue(element, name, value));
                }
                if (this.acceptsElementPre(this.currentParent, element)) {
                    this.context = this.context.push(Action.KEEP);
                    this.currentParent.addChild(element);
                    this.currentParent = element;
                    this.resetActiveText();
                } else {
                    this.context = this.context.push(Action.IGNORE);
                }
            } else {
                this.context = this.context.push(Action.IGNORE);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            LOGGER.trace("endElement()");
            if (this.context.action == Action.KEEP) {
                Element current = (Element)this.currentParent;
                this.checkActiveText(true);
                this.currentParent = ((Child)((Object)this.currentParent)).getParent();
                this.resetActiveText();
                if (!this.acceptsElementPost(current.getParent(), current)) {
                    current.detach();
                }
            }
            this.context = this.context.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            LOGGER.trace("characters()");
            if (this.context.action == Action.KEEP) {
                if (this.activeText == null) {
                    this.activeText = new Text();
                    this.currentParent.addChild(this.activeText);
                }
                this.activeText.appendContent(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            LOGGER.trace("ignorableWhitespace()");
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            LOGGER.trace("comment()");
            if (this.context.action == Action.KEEP) {
                this.checkActiveText(false);
                Comment comment = new Comment(new String(ch, start, length));
                this.currentParent.addChild(comment);
                this.resetActiveText();
            }
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOGGER.warn(this.locator.getLineNumber() + ":" + this.locator.getColumnNumber(), (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOGGER.error(this.locator.getLineNumber() + ":" + this.locator.getColumnNumber(), (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOGGER.fatal(this.locator.getLineNumber() + ":" + this.locator.getColumnNumber(), (Throwable)exception);
            super.fatalError(exception);
        }
    }

    private static class Context {
        private final Context parent;
        private Context child;
        Action action = Action.KEEP;

        public Context(Context parent) {
            this.parent = parent;
        }

        private void setAction(Action action) {
            this.action = this.parent.action == Action.KEEP ? action : Action.IGNORE;
        }

        public Context push(Action action) {
            if (this.child == null) {
                Context result = new Context(this);
                result.setAction(action);
                return result;
            }
            this.child.setAction(action);
            return this.child;
        }

        public Context pop() {
            return this.parent;
        }
    }

    private static enum Action {
        KEEP,
        IGNORE;

    }

    private static class DummyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            LOGGER.debug("resolveEntity('" + publicId + "', '" + systemId + "')");
            return new InputSource(new StringReader(""));
        }
    }

    public static enum Feature {
        LOAD_COMMENTS,
        LOAD_SPACES,
        ALLOW_MIXED_CONTENT,
        SHARE_ATTRIBUTE_NAMES,
        SHARE_ELEMENT_NAMES,
        DUMMY_ENTITY_RESOLVER;

    }
}

