/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.Child;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;

abstract class AbstractChild
implements Child {
    private Parent parent;

    protected AbstractChild() {
    }

    @Override
    public abstract AbstractChild clone(boolean var1);

    @Override
    public final Document getDocument() {
        Element root = this.getRootElement();
        if (root != null) {
            return (Document)root.getParent();
        }
        return (Document)this.getParent();
    }

    @Override
    public final Element getRootElement() {
        Child root = this.getRootChild();
        if (root.getType() == NodeType.DOCUMENT) {
            return ((Document)((Object)root)).getRootElement();
        }
        if (root.getType() == NodeType.ELEMENT) {
            return (Element)root;
        }
        return null;
    }

    @Override
    public final Parent getParent() {
        return this.parent;
    }

    protected final void resetParent() {
        this.parent = null;
    }

    @Override
    public final void setParent(Parent parent) {
        if (parent != this.parent) {
            if (parent == null || parent.canAddChild(this)) {
                if (this.parent != null) {
                    this.parent.getModifiableChildren().remove(this);
                    this.parent = null;
                }
                if (parent != null) {
                    parent.getModifiableChildren().add(this);
                    this.parent = parent;
                }
            } else {
                throw new IllegalStateException("Can not set parent. child: " + (Object)((Object)this.getType()) + " parent: " + (Object)((Object)parent.getType()));
            }
        }
    }

    public String toString() {
        return this.getType().name();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }
}

