/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.AbstractChild;
import cdc.util.data.Leaf;
import cdc.util.data.Node;
import cdc.util.data.Parent;
import java.util.Objects;

abstract class AbstractContentNode
extends AbstractChild
implements Leaf {
    private final StringBuilder content = new StringBuilder();

    protected AbstractContentNode(Parent parent, String content) {
        this.setParent(parent);
        this.setContent(content);
    }

    public final void setContent(String content) {
        if (content != null) {
            this.content.setLength(0);
            this.content.append(content);
        }
    }

    public final void clearContent() {
        this.content.setLength(0);
    }

    public final void appendContent(String text) {
        if (text != null) {
            this.content.append(text);
        }
    }

    public final void appendContent(CharSequence cs, int start, int end) {
        this.content.append(cs, start, end);
    }

    public final void appendContent(char[] str, int offset, int len) {
        this.content.append(str, offset, len);
    }

    public final String getContent() {
        return this.content.toString();
    }

    @Override
    public final boolean deepEquals(Node node) {
        if (node == this) {
            return true;
        }
        if (node == null || !this.getClass().equals(node.getClass())) {
            return false;
        }
        AbstractContentNode other = (AbstractContentNode)node;
        return Objects.equals(this.getContent(), other.getContent());
    }
}

