/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.paths;

import java.util.regex.Pattern;

public class Part {
    private static final Pattern DOT_PATTERN = Pattern.compile("^.$");
    private static final Pattern DOT_DOT_PATTERN = Pattern.compile("^..$");
    private static final Pattern ELEMENT_PATTERN = Pattern.compile("^[\\p{Alnum}_ -]+$");
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("^@[\\p{Alnum}_ -]+$");
    private static final Pattern SELECTOR_PATTERN = Pattern.compile("^[\\p{Alnum}_-]+\\[@[\\p{Alnum}_-]+='[\\p{Alnum}_ -]+'\\]$");
    public static final Part DOT = new Part(".");
    public static final Part DOT_DOT = new Part("..");
    private final Type type;
    private final String name;

    public Part(String name) {
        this.type = Part.getType(name);
        this.name = name;
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid part name:'" + name + "'");
        }
    }

    public static Type getType(String name) {
        if (ELEMENT_PATTERN.matcher(name).find()) {
            return Type.ELEMENT;
        }
        if (ATTRIBUTE_PATTERN.matcher(name).find()) {
            return Type.ATTRIBUTE;
        }
        if (SELECTOR_PATTERN.matcher(name).find()) {
            return Type.SELECTOR;
        }
        if (DOT_PATTERN.matcher(name).find()) {
            return Type.DOT;
        }
        if (DOT_DOT_PATTERN.matcher(name).find()) {
            return Type.DOT_DOT;
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getElementName() {
        if (this.type == Type.ELEMENT) {
            return this.name;
        }
        if (this.type == Type.SELECTOR) {
            return this.name.substring(0, this.name.indexOf(91));
        }
        return null;
    }

    public String getAttributeName() {
        if (this.type == Type.ATTRIBUTE) {
            return this.name.substring(1);
        }
        return null;
    }

    public String getSelectorName() {
        if (this.type == Type.SELECTOR) {
            int start = this.name.indexOf(64) + 1;
            int end = this.name.indexOf(61);
            return this.name.substring(start, end);
        }
        return null;
    }

    public String getSelectorValue() {
        if (this.type == Type.SELECTOR) {
            int start = this.name.indexOf(61) + 2;
            int end = this.name.indexOf(93) - 1;
            return this.name.substring(start, end);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static enum Type {
        ATTRIBUTE,
        ELEMENT,
        SELECTOR,
        DOT,
        DOT_DOT;

    }
}

