/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.cli.FeatureMask;
import cdc.util.cli.OptionEnum;
import cdc.util.data.Attribute;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.paths.SPath;
import cdc.util.data.util.AttributeNameConverter;
import cdc.util.data.util.AttributePredicate;
import cdc.util.data.util.AttributeValueConverter;
import cdc.util.data.util.DataUtil;
import cdc.util.data.util.ElementNameConverter;
import cdc.util.data.util.ElementPredicate;
import cdc.util.data.util.TextContentConverter;
import cdc.util.data.util.TextPredicate;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.function.Predicates;
import cdc.util.io.NonCloseableOutputStream;
import cdc.util.xml.XmlWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class XmlNormalizer {
    protected static final Logger LOGGER = LogManager.getLogger(XmlNormalizer.class);
    private static final String ALIAS_SEPARATOR = "::";
    private final MainArgs margs;

    private XmlNormalizer(MainArgs margs) {
        this.margs = margs;
    }

    private void execute() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.ALLOW_MIXED_CONTENT, true);
        reader.setEnabled(XmlDataReader.Feature.LOAD_COMMENTS, !this.margs.isEnabled(MainArgs.Feature.REMOVE_COMMENTS));
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, !this.margs.isEnabled(MainArgs.Feature.PRETTY_PRINT));
        if (!this.margs.isEnabled(MainArgs.Feature.DELAYED_PROCESSING)) {
            ElementPredicate elementPreFilter = ElementPredicate.ANY_ELEMENT;
            if (!this.margs.removed.isEmpty()) {
                elementPreFilter = ElementPredicate.fromPaths(this.margs.removed).not();
            }
            reader.setElementPreFilter(elementPreFilter);
            Object elementPostFilter = ElementPredicate.ANY_ELEMENT;
            if (this.margs.isEnabled(MainArgs.Feature.REMOVE_PURE_ELEMENTS)) {
                elementPostFilter = ElementPredicate.PURE_ELEMENT.not();
            }
            reader.setElementPostFilter((ElementPredicate)elementPostFilter);
            AttributePredicate attributeFilter = AttributePredicate.ANY_ATTRIBUTE;
            if (this.margs.isEnabled(MainArgs.Feature.REMOVE_EMPTY_ATTRIBUTES)) {
                attributeFilter = AttributePredicate.IS_NOT_EMPTY_ATTRIBUTE;
            }
            if (!this.margs.removed.isEmpty()) {
                attributeFilter = attributeFilter.and(AttributePredicate.fromPaths(this.margs.removed).not());
            }
            reader.setAttributeFilter(attributeFilter);
            if (!this.margs.renamed.isEmpty()) {
                reader.setAttributeNameConverter(AttributeNameConverter.fromPathMap(this.margs.renamed));
                reader.setElementNameConverter(ElementNameConverter.fromPathMap(this.margs.renamed));
            }
            if (!this.margs.set.isEmpty()) {
                reader.setAttributeValueConverter(AttributeValueConverter.fromPathMap(this.margs.set));
            }
        }
        Document document = reader.read(this.margs.inputFile);
        if (this.margs.isEnabled(MainArgs.Feature.DELAYED_PROCESSING)) {
            if (!this.margs.removed.isEmpty()) {
                DataUtil.removeMatchingChildren(document, Element.matching(this.margs.removed), DataUtil.RECURSE);
            }
            if (this.margs.isEnabled(MainArgs.Feature.REMOVE_EMPTY_ATTRIBUTES)) {
                DataUtil.removeEmptyAttributes(document, DataUtil.RECURSE);
            }
            if (!this.margs.removed.isEmpty()) {
                DataUtil.removeMatchingAttributes(document, AttributePredicate.fromPaths(this.margs.removed), DataUtil.RECURSE);
            }
            if (this.margs.isEnabled(MainArgs.Feature.REMOVE_PURE_ELEMENTS)) {
                DataUtil.removePureElements(document, DataUtil.RECURSE);
            }
            if (!this.margs.set.isEmpty()) {
                DataUtil.setValueOfMatchingAttributes(document, AttributePredicate.fromPaths(this.margs.set.keySet()), AttributeValueConverter.fromPathMap(this.margs.set), DataUtil.RECURSE);
            }
            if (!this.margs.renamed.isEmpty()) {
                DataUtil.setNameOfMatchingAttributes(document, AttributePredicate.ANY_ATTRIBUTE, AttributeNameConverter.fromPathMap(this.margs.renamed), DataUtil.RECURSE);
                DataUtil.setNameOfMatchingElements(document, Predicates.alwaysTrue(), ElementNameConverter.fromPathMap(this.margs.renamed), DataUtil.RECURSE);
            }
        }
        if (!this.margs.set.isEmpty()) {
            DataUtil.setContentOfMatchingElements(document, ElementPredicate.fromPaths(this.margs.set.keySet()), TextContentConverter.fromPathMap(this.margs.set), DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SORT_ATTRIBUTES)) {
            DataUtil.sortAttributes(document, Attribute.NAME_COMPARATOR, DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SORT_ELEMENTS)) {
            DataUtil.sortChildren(document, Node.ANY_NODE, Node.ELEMENT_NAME_AND_ATTRIBUTES_COMPARATOR, DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SCRAMBLE_ATTRIBUTES)) {
            DataUtil.setValueOfMatchingAttributes(document, AttributePredicate.ANY_ATTRIBUTE, AttributeValueConverter.scramble(true), DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SCRAMBLE_ELEMENTS)) {
            DataUtil.setContentOfMatchingTexts(document, TextPredicate.ANY_TEXT, TextContentConverter.scramble(true), DataUtil.RECURSE);
        }
        for (String name : this.margs.firstAttributes) {
            DataUtil.moveAttributeFirst(document, Node.ANY_NODE, name, DataUtil.RECURSE);
        }
        if (!this.margs.scrambled.isEmpty()) {
            DataUtil.setValueOfMatchingAttributes(document, AttributePredicate.fromPaths(this.margs.scrambled), AttributeValueConverter.scramble(true), DataUtil.RECURSE);
            DataUtil.setContentOfMatchingTexts(document, TextPredicate.fromElementPaths(this.margs.scrambled), TextContentConverter.scramble(true), DataUtil.RECURSE);
        }
        try (XmlDataWriter writer = this.margs.outputFile == null ? new XmlDataWriter((OutputStream)NonCloseableOutputStream.NON_CLOSABLE_SYSTEM_OUT) : new XmlDataWriter(this.margs.outputFile);){
            writer.getXmlWriter().setEnabled(XmlWriter.Feature.PRETTY_PRINT, this.margs.isEnabled(MainArgs.Feature.PRETTY_PRINT));
            writer.getXmlWriter().setEnabled(XmlWriter.Feature.USE_XML_EOL, this.margs.isEnabled(MainArgs.Feature.USE_XML_EOL));
            writer.getXmlWriter().setEnabled(XmlWriter.Feature.APPEND_FINAL_EOL, this.margs.isEnabled(MainArgs.Feature.APPEND_FINAL_EOL));
            writer.getXmlWriter().setEnabled(XmlWriter.Feature.USE_SINGLE_QUOTE, this.margs.isEnabled(MainArgs.Feature.USE_SINGLE_QUOTE));
            writer.getXmlWriter().setEnabled(XmlWriter.Feature.ALWAYS_ENTITIZE_ATTRIBUTES, this.margs.isEnabled(MainArgs.Feature.ALWAYS_ENTITIZE_ATTRIBUTES));
            writer.getXmlWriter().setIndentString(this.margs.indentString);
            writer.write(document);
            writer.flush();
        }
    }

    public static void execute(MainArgs margs) throws IOException {
        XmlNormalizer instance = new XmlNormalizer(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        private static final String FIRST_ATTRIBUTE = "first-attribute";
        private static final String INDENT_STRING = "indent-string";
        private static final String REMOVE = "remove";
        private static final String RENAME = "rename";
        private static final String SCRAMBLE = "scramble";
        private static final String SET = "set";

        public MainSupport() {
            super(XmlNormalizer.class, LOGGER);
        }

        protected String getVersion() {
            return "0.0.15";
        }

        protected void addSpecificOptions(Options options) {
            options.addOption(Option.builder().longOpt("input").desc("Xml input file.").hasArg().required().build());
            options.addOption(Option.builder().longOpt("output").desc("Optional Xml output file.").hasArg().build());
            options.addOption(Option.builder().longOpt(INDENT_STRING).desc("Optional indentation string. Used when " + MainArgs.Feature.PRETTY_PRINT.getName() + " is enabled").hasArg().build());
            options.addOption(Option.builder().longOpt(FIRST_ATTRIBUTE).desc("Optional name(s) of attributes to move to first position. Order of declarations matters. Executed after attributes sorting.").hasArgs().build());
            options.addOption(Option.builder().longOpt(SCRAMBLE).desc("Optional path(s) of attributes and elements to scramble.").hasArgs().build());
            options.addOption(Option.builder().longOpt(REMOVE).desc("Optional path(s) of attributes and elements to remove.").hasArgs().build());
            options.addOption(Option.builder().longOpt(RENAME).desc("Optional pair(s) (path, alias) of attributes or elements to rename. Has the form: path ::name").hasArgs().build());
            options.addOption(Option.builder().longOpt(SET).desc("Optional pair(s) (path, value) of attributes or elements to set. Has the form: path ::text").hasArgs().build());
            MainSupport.addNoArgOptions((Options)options, MainArgs.Feature.class);
        }

        private static String getName(String s) {
            return MainSupport.getPart1((String)s, (String)XmlNormalizer.ALIAS_SEPARATOR);
        }

        private static String getAlias(String s) throws ParseException {
            String alias = MainSupport.getPart2((String)s, (String)XmlNormalizer.ALIAS_SEPARATOR, null);
            if (alias != null && !alias.isEmpty()) {
                return alias;
            }
            throw new ParseException("Invalid alias arg: '" + s + "'");
        }

        private static void analyzePath(String s, Map<SPath, String> aliases) throws ParseException {
            String name = MainSupport.getName(s);
            String alias = MainSupport.getAlias(s);
            aliases.put(new SPath(name), alias);
        }

        private static void fillPaths(CommandLine cl, String optionName, Collection<SPath> values) {
            if (cl.hasOption(optionName)) {
                for (String s : cl.getOptionValues(optionName)) {
                    values.add(new SPath(s));
                }
            }
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            margs.inputFile = MainSupport.getValueAsNullOrExistingFile((CommandLine)cl, (String)"input", null);
            margs.outputFile = MainSupport.getValueAsFile((CommandLine)cl, (String)"output", null);
            margs.indentString = cl.getOptionValue(INDENT_STRING);
            MainSupport.fillValues((CommandLine)cl, (String)FIRST_ATTRIBUTE, margs.firstAttributes);
            MainSupport.fillPaths(cl, SCRAMBLE, margs.scrambled);
            MainSupport.fillPaths(cl, REMOVE, margs.removed);
            if (cl.getOptionValues(RENAME) != null) {
                for (String s : cl.getOptionValues(RENAME)) {
                    MainSupport.analyzePath(s, margs.renamed);
                }
            }
            if (cl.getOptionValues(SET) != null) {
                for (String s : cl.getOptionValues(SET)) {
                    MainSupport.analyzePath(s, margs.set);
                }
            }
            MainSupport.setMask((CommandLine)cl, MainArgs.Feature.class, (arg_0, arg_1) -> margs.features.setEnabled(arg_0, arg_1));
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            XmlNormalizer.execute(margs);
            return null;
        }
    }

    public static class MainArgs {
        public String indentString = "  ";
        public File inputFile;
        public File outputFile;
        public final List<String> firstAttributes = new ArrayList<String>();
        public final Set<SPath> scrambled = new HashSet<SPath>();
        public final Set<SPath> removed = new HashSet<SPath>();
        public final Map<SPath, String> renamed = new HashMap<SPath, String>();
        public final Map<SPath, String> set = new HashMap<SPath, String>();
        protected final FeatureMask<Feature> features = new FeatureMask();

        public void setEnabled(Feature feature, boolean enabled) {
            this.features.setEnabled((Enum)feature, enabled);
        }

        public boolean isEnabled(Feature feature) {
            return this.features.isEnabled((Enum)feature);
        }

        public static enum Feature implements OptionEnum
        {
            PRETTY_PRINT("pretty-print", "Pretty prints."),
            USE_XML_EOL("use-xml-eol", "Use xml eol instead of platform eol."),
            APPEND_FINAL_EOL("append-final-eol", "Appends a final eol."),
            USE_SINGLE_QUOTE("use-single-quote", "Use single quote (') instead of quote (\") for attributes delimiters."),
            ALWAYS_ENTITIZE_ATTRIBUTES("always-entitize-attributes", "Replaces all special characters by entities in attributes, even if not nexcessary."),
            SORT_ATTRIBUTES("sort-attributes", "Sorts all attributes in alphabetical order."),
            SCRAMBLE_ATTRIBUTES("scramble-attributes", "Scramble values of all attributes. This can alter schema compliance."),
            SORT_ELEMENTS("sort-elements", "Sorts all children elements in alphabetical order. This can alter schema compliance."),
            SCRAMBLE_ELEMENTS("scramble-elements", "Scramble content of all (non-ignorable white space) elements. This can alter schema compliance."),
            REMOVE_EMPTY_ATTRIBUTES("remove-empty-attributes", "Removes all empty attributes. This can alter schema compliance."),
            REMOVE_PURE_ELEMENTS("remove-pure-elements", "Removes all elements that are empty and have no attributes. This can alter schema compliance."),
            REMOVE_COMMENTS("remove-comments", "Removes all comments."),
            DELAYED_PROCESSING("delayed-processing", "If set, propcessing is done after all data has been loaded. Otherwise, it is done during loading, if possible");

            private final String name;
            private final String description;

            private Feature(String name, String description) {
                this.name = name;
                this.description = description;
            }

            public final String getName() {
                return this.name;
            }

            public final String getDescription() {
                return this.description;
            }
        }
    }
}

