/*
 * Decompiled with CFR 0.152.
 */
package cdc.perf.util.data;

import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import cdc.util.data.util.DataStats;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.lang.BlackHole;
import cdc.util.time.Chronometer;
import cdc.util.xml.XmlWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlDataPerf {
    private static final String ROOT = "root";
    private static final String CHILD = "child";
    private static final String INDENT = "  ";

    private XmlDataPerf() {
    }

    private static Document generateDocument(int count) {
        Document doc = new Document();
        Element root = new Element((Parent)doc, ROOT);
        int index = 0;
        while (index < count) {
            root.addElement(CHILD);
            ++index;
        }
        return doc;
    }

    private static void saveDocument(Document doc, File file, XmlWriter.Feature ... features) throws IOException {
        XmlDataWriter.save((Document)doc, (File)file, (String)INDENT, (XmlWriter.Feature[])features);
    }

    private static void writeToFile(File file, int count) throws IOException {
        XmlWriter writer = new XmlWriter(file);
        if (INDENT != null) {
            writer.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.PRETTY_PRINT});
        }
        writer.setIndentString(INDENT);
        writer.beginDocument();
        writer.beginElement(ROOT);
        int index = 0;
        while (index < count) {
            writer.beginElement(CHILD);
            writer.endElement();
            ++index;
        }
        writer.endElement();
        writer.endDocument();
        writer.close();
    }

    private static void writeToMemory(int count) throws IOException {
        XmlWriter writer = new XmlWriter((OutputStream)new ByteArrayOutputStream());
        if (INDENT != null) {
            writer.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.PRETTY_PRINT});
        }
        writer.setIndentString(INDENT);
        writer.beginDocument();
        writer.beginElement(ROOT);
        int index = 0;
        while (index < count) {
            writer.beginElement(CHILD);
            writer.endElement();
            ++index;
        }
        writer.endElement();
        writer.endDocument();
        writer.close();
    }

    private static void rawWriteToMemory1(int count) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(count);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        ((Writer)writer).append("<");
        ((Writer)writer).append(ROOT);
        ((Writer)writer).append(">\n");
        int index = 0;
        while (index < count) {
            ((Writer)writer).append(INDENT);
            ((Writer)writer).append("<");
            ((Writer)writer).append(CHILD);
            ((Writer)writer).append("/>\n");
            ++index;
        }
        ((Writer)writer).append("</");
        ((Writer)writer).append(ROOT);
        ((Writer)writer).append(">");
        ((Writer)writer).close();
    }

    private static void rawWriteToMemory2(int count) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(count);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        ((Writer)writer).append("<root>\n");
        int index = 0;
        while (index < count) {
            ((Writer)writer).append("  <child/>\n");
            ++index;
        }
        ((Writer)writer).append("</root>");
        ((Writer)writer).close();
    }

    private static Document load(File file) throws IOException {
        XmlDataReader reader = new XmlDataReader(new XmlDataReader.Feature[]{XmlDataReader.Feature.SHARE_ATTRIBUTE_NAMES, XmlDataReader.Feature.SHARE_ELEMENT_NAMES});
        Document doc = reader.read(file);
        return doc;
    }

    private static void parse1(File file) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            Handler handler = new Handler();
            SAXParser parser = factory.newSAXParser();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            InputSource source = new InputSource(is);
            source.setSystemId(file.getPath());
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    private static void parse2(File file) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            Handler handler = new Handler();
            SAXParser parser = factory.newSAXParser();
            FileInputStream is = new FileInputStream(file);
            InputSource source = new InputSource(is);
            source.setSystemId(file.getPath());
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    private static void read1(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream is = new FileInputStream(file);){
            int i;
            while ((i = ((InputStream)is).read()) > 0) {
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void read2(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int i;
            while ((i = ((InputStream)is).read()) > 0) {
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void print(String message, int count, Chronometer chrono) {
        System.out.println(String.format("%40s %12s %,11d e/s", message, chrono.toString(), (int)((double)count / chrono.getElapsedSeconds())));
    }

    private static void test1() throws IOException {
        Chronometer chrono = new Chronometer();
        File file = new File("test.xml");
        int k = 0;
        while (k < 24) {
            int l = 0;
            while (l < 5) {
                int count = (int)Math.round(Math.pow(2.0, k));
                System.out.println("-----------------------------------------");
                System.out.println(String.format("count: %,d", count));
                chrono.start();
                Document doc1 = XmlDataPerf.generateDocument(count);
                chrono.suspend();
                XmlDataPerf.print("generate: ", count, chrono);
                chrono.start();
                XmlDataPerf.saveDocument(doc1, file, new XmlWriter.Feature[0]);
                chrono.suspend();
                XmlDataPerf.print("save no features: ", count, chrono);
                chrono.start();
                XmlDataPerf.saveDocument(doc1, file, XmlWriter.Feature.DONT_VALIDATE_NAMES);
                chrono.suspend();
                XmlDataPerf.print("save no name validation: ", count, chrono);
                chrono.start();
                XmlDataPerf.saveDocument(doc1, file, XmlWriter.Feature.DONT_VALIDATE_NAMES, XmlWriter.Feature.DONT_VALIDATE_CHARS);
                chrono.suspend();
                XmlDataPerf.print("save no name and chars validation: ", count, chrono);
                chrono.start();
                XmlDataPerf.parse1(file);
                chrono.suspend();
                XmlDataPerf.print("parse1: ", count, chrono);
                chrono.start();
                XmlDataPerf.parse2(file);
                chrono.suspend();
                XmlDataPerf.print("parse2: ", count, chrono);
                chrono.start();
                XmlDataPerf.read2(file);
                chrono.suspend();
                XmlDataPerf.print("read2: ", count, chrono);
                file.delete();
                chrono.start();
                XmlDataPerf.writeToFile(file, count);
                chrono.suspend();
                XmlDataPerf.print("xml file: ", count, chrono);
                chrono.start();
                XmlDataPerf.writeToMemory(count);
                chrono.suspend();
                XmlDataPerf.print("xml mem: ", count, chrono);
                chrono.start();
                XmlDataPerf.rawWriteToMemory1(count);
                chrono.suspend();
                XmlDataPerf.print("raw mem1: ", count, chrono);
                chrono.start();
                XmlDataPerf.rawWriteToMemory2(count);
                chrono.suspend();
                XmlDataPerf.print("raw mem2: ", count, chrono);
                chrono.start();
                Document doc = XmlDataPerf.load(file);
                BlackHole.discard((Object)doc);
                chrono.suspend();
                XmlDataPerf.print("load: ", count, chrono);
                ++l;
            }
            ++k;
        }
    }

    private static void test2() throws IOException {
        int count = 0x2000000;
        File file = new File("test.xml");
        Chronometer chrono = new Chronometer();
        chrono.start();
        XmlDataPerf.writeToFile(file, 0x2000000);
        XmlDataPerf.print("xml file: ", 0x2000000, chrono);
    }

    private static void test3() throws IOException {
        File file = new File("/home/damien/z2M.xml");
        Chronometer chrono = new Chronometer();
        int i = 0;
        while (i < 10) {
            chrono.start();
            Document doc = XmlDataPerf.load(file);
            System.out.println("stats");
            DataStats stats = new DataStats((Node)doc);
            stats.print(System.out);
            chrono.suspend();
            XmlDataPerf.print("load: ", stats.getNodesCount(NodeType.ELEMENT), chrono);
            chrono.start();
            XmlDataPerf.parse1(file);
            chrono.suspend();
            XmlDataPerf.print("parse1: ", stats.getNodesCount(NodeType.ELEMENT), chrono);
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        XmlDataPerf.test1();
    }

    private static class Handler
    extends DefaultHandler2 {
    }
}

