/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.lang.Checks;
import cdc.util.lang.CollectionsUtil;
import cdc.util.lang.Operators;
import cdc.util.strings.StringConversion;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;

public final class Attribute {
    private final String name;
    private String value;
    public static final Comparator<Attribute> NAME_COMPARATOR = (o1, o2) -> o1.name.compareTo(o2.name);

    public Attribute(String name) {
        Checks.isNotNull((Object)name, (String)"name");
        this.name = name;
    }

    public Attribute(Attribute other) {
        this(other.name, other.value);
    }

    public Attribute(String name, Object value) {
        this(name);
        this.setValue(value);
    }

    public <E extends Enum<E>> Attribute(String name, E value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, String value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, boolean value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, long value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, int value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, short value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, byte value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, double value) {
        this(name);
        this.setValue(value);
    }

    public Attribute(String name, float value) {
        this(name);
        this.setValue(value);
    }

    public void setValue(Object value) {
        this.value = value == null ? null : value.toString();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(boolean value) {
        this.value = StringConversion.asString((boolean)value);
    }

    public void setValue(long value) {
        this.value = StringConversion.asString((long)value);
    }

    public void setValue(int value) {
        this.value = StringConversion.asString((int)value);
    }

    public void setValue(short value) {
        this.value = StringConversion.asString((short)value);
    }

    public void setValue(byte value) {
        this.value = StringConversion.asString((byte)value);
    }

    public void setValue(double value) {
        this.value = StringConversion.asString((double)value);
    }

    public void setValue(float value) {
        this.value = StringConversion.asString((float)value);
    }

    public <E extends Enum<E>> void setValue(E value) {
        this.value = StringConversion.asString(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getValueAsBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    public long getValueAsLong() {
        return Long.parseLong(this.value);
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.value);
    }

    public short getValueAsShort() {
        return Short.parseShort(this.value);
    }

    public byte getValueAsByte() {
        return Byte.parseByte(this.value);
    }

    public double getValueAsDouble() {
        return Double.parseDouble(this.value);
    }

    public float getValueAsFloat() {
        return Float.parseFloat(this.value);
    }

    public <E extends Enum<E>> E getValueAsEnum(Class<E> enumClass) {
        return (E)StringConversion.asEnum((String)this.value, enumClass);
    }

    public int hashCode() {
        return this.name.hashCode() + Operators.hashCode((Object)this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)object;
        return this.name.equals(other.name) && Operators.equals((Object)this.value, (Object)other.value);
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.value;
    }

    public static Predicate<Attribute> named(String name) {
        return att -> att.getName().equals(name);
    }

    public static Predicate<Attribute> named(Set<String> names) {
        return att -> names.contains(att.getName());
    }

    public static Predicate<Attribute> named(String ... names) {
        return Attribute.named(CollectionsUtil.toSet((Object[])names));
    }
}

