/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.Child;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import java.util.ArrayList;
import java.util.List;

public final class Document
implements Parent {
    private final List<Child> children = new ArrayList<Child>();

    @Override
    public NodeType getType() {
        return NodeType.DOCUMENT;
    }

    @Override
    public Document clone(boolean recurse) {
        Document result = new Document();
        if (recurse) {
            for (Child child : this.getChildren()) {
                result.addChild(child.clone(true));
            }
        }
        return result;
    }

    @Override
    public boolean deepEquals(Node node) {
        if (this == node) {
            return true;
        }
        if (!(node instanceof Document)) {
            return false;
        }
        Document other = (Document)node;
        if (this.getChildrenCount() == other.getChildrenCount()) {
            int index = 0;
            while (index < this.getChildrenCount()) {
                if (!this.getChildAt(index).deepEquals(other.getChildAt(index))) {
                    return false;
                }
                ++index;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getQName() {
        return "/";
    }

    @Override
    public Document getDocument() {
        return this;
    }

    @Override
    public Element getRootElement() {
        for (Child child : this.children) {
            if (child.getType() != NodeType.ELEMENT) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getRootElement(Document document) {
        return document == null ? null : document.getRootElement();
    }

    @Override
    public boolean canAddChild(Child child) {
        if (child == null) {
            return false;
        }
        if (child.getType() == NodeType.ELEMENT) {
            return this.getRootElement() == null;
        }
        return true;
    }

    @Override
    public List<Child> getModifiableChildren() {
        return this.children;
    }

    public List<Child> getChildren() {
        return this.getModifiableChildren();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

