/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.AbstractChild;
import cdc.util.data.Attribute;
import cdc.util.data.Child;
import cdc.util.data.ElementContentType;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import cdc.util.data.paths.SPath;
import cdc.util.function.Iterables;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionsUtil;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.NotFoundException;
import cdc.util.lang.Operators;
import cdc.util.lang.UnexpectedValueException;
import cdc.util.strings.StringConversion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Element
extends AbstractChild
implements Parent {
    private static final Logger LOGGER = LogManager.getLogger(Element.class);
    private String name;
    private List<Attribute> attributes = null;
    private List<Child> children = null;
    public static final Comparator<Element> NAME_COMPARATOR = (o1, o2) -> {
        String name1 = o1 == null ? null : o1.getName();
        String name2 = o2 == null ? null : o2.getName();
        return Operators.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
    };

    public static Comparator<Element> compareAttribute(String attributeName) {
        return (o1, o2) -> {
            String value1 = o1 == null ? null : o1.getAttributeValue(attributeName, null, FailureReaction.WARN);
            String value2 = o2 == null ? null : o2.getAttributeValue(attributeName, null, FailureReaction.WARN);
            return Operators.compare((Comparable)((Object)value1), (Comparable)((Object)value2));
        };
    }

    public static Comparator<Element> compareNameAndAttribute(String attributeName) {
        return (o1, o2) -> {
            String name2;
            String name1 = o1 == null ? null : o1.getName();
            int nameCmp = Operators.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = o2 == null ? null : o2.getName())));
            if (nameCmp == 0) {
                String value1 = o1.getAttributeValue(attributeName, null, FailureReaction.WARN);
                String value2 = o2.getAttributeValue(attributeName, null, FailureReaction.WARN);
                return Operators.compare((Comparable)((Object)value1), (Comparable)((Object)value2));
            }
            return nameCmp;
        };
    }

    public Element(String name) {
        this(null, name);
    }

    public Element(Parent parent, String name) {
        this.setName(name);
        this.setParent(parent);
    }

    public Element(Element other) {
        this(null, other.getName());
        int index = 0;
        while (index < other.getAttributesCount()) {
            this.addAttribute(new Attribute(other.getAttributeAt(index)));
            ++index;
        }
    }

    @Override
    public NodeType getType() {
        return NodeType.ELEMENT;
    }

    @Override
    public Element clone(boolean recurse) {
        Element result = new Element(this);
        if (recurse) {
            for (Child child : this.getChildren()) {
                result.addChild(child.clone(true));
            }
        }
        return result;
    }

    private boolean localEquals(Element element) {
        if (!Operators.equals((Object)this.name, (Object)element.name) || this.getAttributesCount() != element.getAttributesCount()) {
            return false;
        }
        if (this.getAttributesCount() != 0) {
            ArrayList<Attribute> atts0 = new ArrayList<Attribute>(this.attributes);
            ArrayList<Attribute> atts1 = new ArrayList<Attribute>(element.attributes);
            atts0.sort(Attribute.NAME_COMPARATOR);
            atts1.sort(Attribute.NAME_COMPARATOR);
            return atts0.equals(atts1);
        }
        return true;
    }

    @Override
    public boolean deepEquals(Node node) {
        if (this == node) {
            return true;
        }
        if (!(node instanceof Element)) {
            return false;
        }
        Element other = (Element)node;
        if (this.getChildrenCount() == other.getChildrenCount() && this.localEquals(other)) {
            int index = 0;
            while (index < this.getChildrenCount()) {
                if (!this.getChildAt(index).deepEquals(other.getChildAt(index))) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getQName() {
        if (this.isRoot()) {
            return "/" + this.getName();
        }
        return String.valueOf(this.getParent().getQName()) + "/" + this.getName();
    }

    @Override
    public boolean canAddChild(Child child) {
        if (child == null) {
            return false;
        }
        if (child.getType() == NodeType.ELEMENT) {
            return true;
        }
        return true;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public List<Child> getModifiableChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Child>();
        }
        return this.children;
    }

    public List<Child> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public void setName(String name) {
        Checks.isNotNullOrEmpty((String)name, (String)"name");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ElementContentType getContentType() {
        if (this.children == null || this.children.isEmpty()) {
            return ElementContentType.EMPTY;
        }
        boolean hasText = false;
        boolean hasNonText = false;
        for (Child child : this.children) {
            switch (child.getType()) {
                case COMMENT: 
                case ELEMENT: {
                    hasNonText = true;
                    break;
                }
                case TEXT: {
                    hasText = true;
                    break;
                }
                default: {
                    throw new UnexpectedValueException((Enum)child.getType());
                }
            }
        }
        if (hasNonText) {
            if (hasText) {
                return ElementContentType.MIXED;
            }
            return ElementContentType.NON_TEXT;
        }
        return ElementContentType.TEXT;
    }

    public boolean isEmpty() {
        return this.getContentType() == ElementContentType.EMPTY;
    }

    public boolean isPure() {
        return this.isEmpty() && !this.hasAttributes();
    }

    public boolean hasOnlyText() {
        return this.getContentType() == ElementContentType.TEXT;
    }

    public boolean hasOnlyNonText() {
        return this.getContentType() == ElementContentType.NON_TEXT;
    }

    public boolean isMixed() {
        return this.getContentType() == ElementContentType.MIXED;
    }

    public boolean isRoot() {
        return this.getParent() == null || this.getParent().getType() == NodeType.DOCUMENT;
    }

    public List<Attribute> getAttributes() {
        return this.attributes == null ? Collections.emptyList() : this.attributes;
    }

    public List<Attribute> getSortedAttributes() {
        ArrayList<Attribute> sorted = new ArrayList<Attribute>(this.getAttributes());
        if (sorted.size() > 1) {
            Collections.sort(sorted, Attribute.NAME_COMPARATOR);
        }
        return sorted;
    }

    public int getAttributesCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public Attribute getAttributeAt(int index) {
        return this.attributes.get(index);
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public Attribute getAttribute(String name) {
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
        }
        return null;
    }

    public int getAttributeIndex(String name) {
        if (this.attributes != null) {
            int index = 0;
            while (index < this.attributes.size()) {
                if (this.attributes.get(index).getName().equals(name)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public String getAttributeValue(String name, String def, FailureReaction missingReaction) {
        Attribute att = this.getAttribute(name);
        if (att == null) {
            if (missingReaction == FailureReaction.DEFAULT) {
                return def;
            }
            if (missingReaction == FailureReaction.WARN) {
                LOGGER.warn("No attribute named '" + name + "'");
                return def;
            }
            throw new NotFoundException("No attribute named '" + name + "'");
        }
        return att.getValue();
    }

    public String getAttributeValue(String name, String def) {
        return this.getAttributeValue(name, def, FailureReaction.DEFAULT);
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, null, FailureReaction.FAIL);
    }

    public boolean getAttributeAsBoolean(String name, boolean def) {
        return StringConversion.asBoolean((String)this.getAttributeValue(name, null), (boolean)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Boolean getAttributeAsOptionalBoolean(String name, Boolean def) {
        return StringConversion.asOptionalBoolean((String)this.getAttributeValue(name, null), (Boolean)def, (FailureReaction)FailureReaction.WARN);
    }

    public long getAttributeAsLong(String name, long def) {
        return StringConversion.asLong((String)this.getAttributeValue(name, null), (long)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Long getAttributeAsOptionalLong(String name, Long def) {
        return StringConversion.asOptionalLong((String)this.getAttributeValue(name, null), (Long)def, (FailureReaction)FailureReaction.WARN);
    }

    public int getAttributeAsInt(String name, int def) {
        return StringConversion.asInt((String)this.getAttributeValue(name, null), (int)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Integer getAttributeAsOptionalInt(String name, Integer def) {
        return StringConversion.asOptionalInt((String)this.getAttributeValue(name, null), (Integer)def, (FailureReaction)FailureReaction.WARN);
    }

    public short getAttributeAsShort(String name, short def) {
        return StringConversion.asShort((String)this.getAttributeValue(name, null), (short)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Short getAttributeAsOptionalShort(String name, Short def) {
        return StringConversion.asOptionalShort((String)this.getAttributeValue(name, null), (Short)def, (FailureReaction)FailureReaction.WARN);
    }

    public byte getAttributeAsByte(String name, byte def) {
        return StringConversion.asByte((String)this.getAttributeValue(name, null), (byte)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Byte getAttributeAsOptionalByte(String name, Byte def) {
        return StringConversion.asOptionalByte((String)this.getAttributeValue(name, null), (Byte)def, (FailureReaction)FailureReaction.WARN);
    }

    public double getAttributeAsDouble(String name, double def) {
        return StringConversion.asDouble((String)this.getAttributeValue(name, null), (double)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Double getAttributeAsOptionalDouble(String name, Double def) {
        return StringConversion.asOptionalDouble((String)this.getAttributeValue(name, null), (Double)def, (FailureReaction)FailureReaction.WARN);
    }

    public float getAttributeAsFloat(String name, float def) {
        return StringConversion.asFloat((String)this.getAttributeValue(name, null), (float)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Float getAttributeAsOptionalFloat(String name, Float def) {
        return StringConversion.asOptionalFloat((String)this.getAttributeValue(name, null), (Float)def, (FailureReaction)FailureReaction.WARN);
    }

    public Enum<?> getAttributeAsRawEnum(String name, Class<? extends Enum<?>> enumClass, Enum<?> def) {
        return StringConversion.asRawEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Enum<?> getAttributeAsOptionalRawEnum(String name, Class<? extends Enum<?>> enumClass, Enum<?> def) {
        return StringConversion.asOptionalRawEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)FailureReaction.WARN);
    }

    public <E extends Enum<E>> E getAttributeAsEnum(String name, Class<E> enumClass, E def) {
        return (E)StringConversion.asEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public <E extends Enum<E>> E getAttributeAsOptionalEnum(String name, Class<E> enumClass, E def) {
        return (E)StringConversion.asOptionalEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)FailureReaction.WARN);
    }

    public void addAttribute(Attribute attribute) {
        Checks.isNotNull((Object)attribute, (String)"attribute");
        if (this.hasAttribute(attribute.getName())) {
            throw new IllegalArgumentException("Duplicate eattribute");
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(attribute);
    }

    public void addAttributes(Collection<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.addAttribute(attribute);
        }
    }

    public void addAttributes(Attribute ... attributes) {
        Attribute[] attributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            this.addAttribute(attribute);
            ++n2;
        }
    }

    public void addAttribute(String name, Object value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, String value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, boolean value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, long value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, int value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, short value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, byte value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, double value) {
        this.addAttribute(new Attribute(name, value));
    }

    public void addAttribute(String name, float value) {
        this.addAttribute(new Attribute(name, value));
    }

    public Attribute removeAttribute(String name) {
        int index = this.getAttributeIndex(name);
        if (index >= 0) {
            return this.attributes.remove(index);
        }
        return null;
    }

    public void removeAttributes(Predicate<Attribute> predicate) {
        Iterator<Attribute> atts = this.getAttributes().iterator();
        while (atts.hasNext()) {
            Attribute att = atts.next();
            if (!predicate.test(att)) continue;
            atts.remove();
        }
    }

    public void removeAttributes(Predicate<Attribute> predicate, boolean recurse) {
        this.removeAttributes(predicate);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.removeAttributes(predicate, true);
            }
        }
    }

    public void removeAttributesNamed(String name) {
        this.removeAttributes(Attribute.named(name));
    }

    public void removeAttributesNamed(String name, boolean recurse) {
        this.removeAttributes(Attribute.named(name), recurse);
    }

    public void removeAttributesNamed(Set<String> names) {
        this.removeAttributes(Attribute.named(names));
    }

    public void removeAttributesNamed(Set<String> names, boolean recurse) {
        this.removeAttributes(Attribute.named(names), recurse);
    }

    public void removeAttributesNamed(String ... names) {
        this.removeAttributes(Attribute.named(names));
    }

    public void removeAttributes() {
        this.attributes.clear();
    }

    public void changeAttributeValue(String name, UnaryOperator<String> modifier) {
        Attribute att = this.getAttribute(name);
        if (att != null) {
            String modified = (String)modifier.apply(att.getValue());
            att.setValue(modified);
        }
    }

    public void changeAttributeValue(String name, UnaryOperator<String> modifier, boolean recurse) {
        this.changeAttributeValue(name, modifier);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.changeAttributeValue(name, modifier, true);
            }
        }
    }

    public void changeName(UnaryOperator<String> modifier) {
        String newName = (String)modifier.apply(this.getName());
        if (Operators.notEquals((Object)this.getName(), (Object)newName)) {
            this.setName(newName);
        }
    }

    public void changeName(UnaryOperator<String> modifier, boolean recurse) {
        this.changeName(modifier);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.changeName(modifier, true);
            }
        }
    }

    public Text addText(String content, boolean merge) {
        Child last;
        if (merge && (last = this.getLastChild()) != null && last.getType() == NodeType.TEXT) {
            ((Text)last).appendContent(content);
            return (Text)last;
        }
        Text result = new Text(content);
        this.addChild(result);
        return result;
    }

    public Text addText(String content) {
        return this.addText(content, true);
    }

    public String getText(String def) {
        if (this.children == null || this.children.isEmpty()) {
            return def;
        }
        if (!this.hasChildren(Element.class)) {
            Iterable<Text> texts = this.getChildren(Text.class);
            if (Iterables.isEmpty(texts)) {
                return def;
            }
            StringBuilder sb = new StringBuilder();
            for (Text text : texts) {
                sb.append(text.getContent());
            }
            return sb.toString();
        }
        return def;
    }

    public String getText() {
        return this.getText(null);
    }

    public boolean getTextAsBoolean(boolean def) {
        return StringConversion.asBoolean((String)this.getText(), (boolean)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Boolean getTextAsOptionalBoolean(Boolean def) {
        return StringConversion.asOptionalBoolean((String)this.getText(), (Boolean)def, (FailureReaction)FailureReaction.WARN);
    }

    public long getTextAsLong(long def) {
        return StringConversion.asLong((String)this.getText(), (long)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Long getTextAsOptionalLong(Long def) {
        return StringConversion.asOptionalLong((String)this.getText(), (Long)def, (FailureReaction)FailureReaction.WARN);
    }

    public int getTextAsInt(int def) {
        return StringConversion.asInt((String)this.getText(), (int)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Integer getTextAsOptionalInt(Integer def) {
        return StringConversion.asOptionalInt((String)this.getText(), (Integer)def, (FailureReaction)FailureReaction.WARN);
    }

    public short getTextAsShort(short def) {
        return StringConversion.asShort((String)this.getText(), (short)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Short getTextAsOptionalShort(Short def) {
        return StringConversion.asOptionalShort((String)this.getText(), (Short)def, (FailureReaction)FailureReaction.WARN);
    }

    public byte getTextAsByte(byte def) {
        return StringConversion.asByte((String)this.getText(), (byte)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Byte getTextAsOptionalByte(Byte def) {
        return StringConversion.asOptionalByte((String)this.getText(), (Byte)def, (FailureReaction)FailureReaction.WARN);
    }

    public double getTextAsDouble(double def) {
        return StringConversion.asDouble((String)this.getText(), (double)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Double getTextAsOptionalDouble(Double def) {
        return StringConversion.asOptionalDouble((String)this.getText(), (Double)def, (FailureReaction)FailureReaction.WARN);
    }

    public float getTextAsFloat(float def) {
        return StringConversion.asFloat((String)this.getText(), (float)def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public Float getTextAsOptionalFloat(Float def) {
        return StringConversion.asOptionalFloat((String)this.getText(), (Float)def, (FailureReaction)FailureReaction.WARN);
    }

    public <E extends Enum<E>> E getTextAsEnum(Class<E> enumClass, E def) {
        return (E)StringConversion.asEnum((String)this.getText(), enumClass, def, (FailureReaction)FailureReaction.DEFAULT, (FailureReaction)FailureReaction.WARN);
    }

    public <E extends Enum<E>> E getTextAsOptionalEnum(Class<E> enumClass, E def) {
        return (E)StringConversion.asOptionalEnum((String)this.getText(), enumClass, def, (FailureReaction)FailureReaction.WARN);
    }

    public String getElementNamedText(String name, String def) {
        Element child = this.getElementNamed(name);
        if (child != null) {
            return child.getText(def);
        }
        return def;
    }

    public String getElementNamedText(String name) {
        return this.getElementNamedText(name, null);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[" + (Object)((Object)this.getType()) + " " + this.getName());
        for (Attribute att : this.getAttributes()) {
            builder.append(" " + att.getName() + "='" + att.getValue() + "'");
        }
        builder.append("]");
        return builder.toString();
    }

    public static Predicate<Node> named(String name) {
        return node -> node.getType() == NodeType.ELEMENT && ((Element)node).getName().equals(name);
    }

    public static Predicate<Node> named(Set<String> names) {
        return node -> node.getType() == NodeType.ELEMENT && names.contains(((Element)node).getName());
    }

    public static Predicate<Node> named(String ... names) {
        return Element.named(CollectionsUtil.toSet((Object[])names));
    }

    public static Predicate<Node> matching(Set<SPath> paths) {
        return node -> {
            if (node.getType() == NodeType.ELEMENT) {
                Element element = (Element)node;
                for (SPath path : paths) {
                    if (!path.matchesElement(element)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static Predicate<Node> namedWithAttribute(String name, String attributeName, String attributeValue) {
        return node -> {
            if (node.getType() == NodeType.ELEMENT) {
                Element e = (Element)node;
                return e.getName().equals(name) && Operators.equals((Object)e.getAttributeValue(attributeName, null), (Object)attributeValue);
            }
            return false;
        };
    }

    public static Predicate<Node> hasAttribute(String attributeName, String attributeValue) {
        return node -> {
            if (node.getType() == NodeType.ELEMENT) {
                Element e = (Element)node;
                return Operators.equals((Object)e.getAttributeValue(attributeName, null), (Object)attributeValue);
            }
            return false;
        };
    }

    public static Predicate<Node> namedIgnoreCase(String name) {
        return node -> node.getType() == NodeType.ELEMENT && ((Element)node).getName().equalsIgnoreCase(name);
    }
}

