/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.paths;

import cdc.util.data.paths.Part;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Path {
    private static final Logger LOGGER = LogManager.getLogger(Path.class);
    private final String name;
    private final Part[] parts;

    public Path(String name) {
        this.name = name == null ? "" : name;
        this.parts = new Part[Path.getNumParts(this.name)];
        this.buildParts();
    }

    private Path(Part ... parts) {
        if (parts.length == 0) {
            throw new IllegalArgumentException("Invalid number of parts: 0");
        }
        this.parts = new Part[parts.length];
        int index = 0;
        while (index < parts.length) {
            this.parts[index] = parts[index];
            ++index;
        }
        this.name = Path.buildName(this.parts);
    }

    private static Part[] normalize(Part ... parts) {
        ArrayList<Part> tmp = new ArrayList<Part>();
        Part[] partArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Part part = partArray[n2];
            tmp.add(part);
            ++n2;
        }
        Path.normalize(tmp);
        Part[] result = new Part[tmp.size()];
        return tmp.toArray(result);
    }

    private static void normalize(List<Part> parts) {
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty parts");
        }
        int index = 1;
        while (index < parts.size()) {
            Part part1 = parts.get(index - 1);
            Part part2 = parts.get(index);
            block0 : switch (part2.getType()) {
                case DOT: {
                    parts.remove(index);
                    break;
                }
                case DOT_DOT: {
                    switch (part1.getType()) {
                        case ATTRIBUTE: 
                        case ELEMENT: 
                        case SELECTOR: {
                            parts.remove(index);
                            parts.remove(index - 1);
                            if (--index != 0) break block0;
                            parts.add(0, Part.DOT);
                            index = 1;
                            break block0;
                        }
                        case DOT: {
                            parts.remove(index - 1);
                            break block0;
                        }
                        case DOT_DOT: {
                            ++index;
                            break block0;
                        }
                    }
                    break;
                }
                case ATTRIBUTE: 
                case ELEMENT: 
                case SELECTOR: {
                    ++index;
                    break;
                }
            }
        }
        if (parts.size() > 1 && parts.get(0).getType() == Part.Type.DOT) {
            parts.remove(0);
        }
    }

    private static int getNumParts(String code) {
        int count = 0;
        int index = 0;
        while (index < code.length()) {
            if (code.charAt(index) == '/') {
                ++count;
            }
            ++index;
        }
        return count + 1;
    }

    private void buildParts() {
        int prev = 0;
        int index = 0;
        while (prev >= 0) {
            Part part;
            int next = this.name.indexOf(47, prev);
            if (next >= 0) {
                part = new Part(this.name.substring(prev, next));
                prev = next + 1;
            } else {
                part = new Part(this.name.substring(prev));
                prev = -1;
            }
            this.parts[index] = part;
            ++index;
        }
    }

    private static String buildName(Part ... parts) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        Part[] partArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Part part = partArray[n2];
            if (!first) {
                builder.append('/');
            }
            builder.append(part.getName());
            first = false;
            ++n2;
        }
        return builder.toString();
    }

    public Path normalize() {
        return new Path(Path.normalize(this.parts));
    }

    public String getName() {
        return this.name;
    }

    public Part[] getParts() {
        return this.parts;
    }

    public Part getPart(int index) {
        return this.parts[index];
    }

    public Part getLastPart() {
        return this.parts[this.parts.length - 1];
    }

    public int getLength() {
        return this.parts.length;
    }

    public Path getParent() {
        Part[] tmp = new Part[this.parts.length + 1];
        int index = 0;
        while (index < this.parts.length) {
            tmp[index] = this.parts[index];
            ++index;
        }
        tmp[tmp.length - 1] = Part.DOT_DOT;
        return new Path(Path.normalize(tmp));
    }

    public Path getSubPath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > this.getLength()) {
            throw new IllegalArgumentException("Invalid beginIndex (" + this + ", " + beginIndex + ", " + endIndex + ")");
        }
        if (endIndex < beginIndex || endIndex > this.getLength()) {
            throw new IllegalArgumentException("Invalid endIndex (" + this + ", " + beginIndex + ", " + endIndex + ")");
        }
        if (beginIndex == endIndex) {
            return new Path(".");
        }
        Part[] tmp = new Part[endIndex - beginIndex];
        int index = beginIndex;
        while (index < endIndex) {
            tmp[index - beginIndex] = this.parts[index];
            ++index;
        }
        return new Path(Path.normalize(tmp));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Path)) {
            return false;
        }
        Path o = (Path)other;
        return this.name.equals(o.name);
    }

    public String toString() {
        return this.name;
    }
}

